<?php
	global $wplab_albedo_core;
	$attributes = $classes = array();

	$id = esc_attr( $atts['el_id'] );

	/** unique id **/
	$attributes[] = 'id="shortcode-' . $id . '"';
	$attributes[] = 'data-effect="' . esc_attr( $atts['animation_effect'] ) . '"';

	$terms = in_array( $atts['query_type'], array('only', 'except') ) ? $atts['cats'] : '';

  $items = $wplab_albedo_core->model('post')->get( array(
    'post_type' => 'team',
    'type' => $atts['query_type'],
    'posts_per_page' => absint( $atts['posts_per_page'] ),
    'order' => $atts['order_by'],
    'sort' => $atts['sort_by'],
    'tax_name' => 'team_category',
    'term_field' => 'slug',
    'terms' => $terms
  ) );

?>

<div class="team-members-tabs <?php echo implode(' ', $classes); ?>" <?php echo implode( ' ', $attributes ); ?>>

	<div class="row">

		<div class="col-md-4 tm-tabs-left">

			<?php if( $atts['block_title'] <> '' ): ?>
			<h3><?php echo wp_kses_post( $atts['block_title'] ); ?></h3>
			<?php endif; ?>

			<?php if( $atts['block_text'] <> '' ): ?>
			<div class="desc"><?php echo wp_kses_post( $atts['block_text'] ); ?></div>
			<?php endif; ?>

			<div class="previews">

				<?php while ( $items->have_posts() ): $items->the_post(); ?>
					<?php $photo = get_the_post_thumbnail_url( get_the_ID(), 'full'); ?>
					<a href="javascript:;">
						<?php if( $photo <> '' ): ?>
							<?php echo wplab_albedo_media::image( $photo, 60, 60, true, true, $photo ); ?>
						<?php else: ?>
							<span class="placeholder"></span>
						<?php endif; ?>
					</a>
				<?php endwhile; wp_reset_postdata(); ?>

			<div class="clearfix"></div>
			</div>

		</div>

		<div class="col-md-8 tm-tabs-right">

			<?php while ( $items->have_posts() ): $items->the_post(); ?>

				<?php
					$text = get_the_content();
					$name = get_the_title();
					$position = fw_get_db_post_option( get_the_ID(), 'position' );
					$photo = fw_get_db_post_option( get_the_ID(), 'content_photo' );
					$photo_url = isset( $photo['url'] ) ? $photo['url'] : '';
				?>

			<div class="row">

				<?php if( $photo_url <> '' ): ?>
				<div class="col-md-5 col col-big-photo">
					<?php echo wplab_albedo_media::image( $photo_url, null, null, true, true, $photo_url ); ?>
				</div>
				<?php endif; ?>

				<div class="col-md-<?php echo $photo <> '' ? '7' : '12'; ?> col col-text">

					<?php if( $name <> '' ): ?>
					<h4><?php echo $name; ?></h4>
					<?php endif; ?>

					<?php if( $position <> '' ): ?>
					<div class="position"><?php echo $position; ?></div>
					<?php endif; ?>

					<?php if( $text <> '' ): ?>
					<div class="text"><?php echo $text; ?></div>
					<?php endif; ?>

					<div class="social">
						<?php
							$custom_fields = get_post_custom();
							$fields = isset( $custom_fields['fw_options'][0] ) ? unserialize( $custom_fields['fw_options'][0] ) : array();
							wplab_albedo_front::print_fa_icons( $fields );
						?>
					</div>

				</div>

			</div>

			<?php endwhile; wp_reset_postdata(); ?>

		</div>

	</div>

</div>
