<?php

	$attributes = $classes = array();
	$animated = filter_var( $atts['animate_on_display'], FILTER_VALIDATE_BOOLEAN );
	$animation = $animated ? $atts['animate_on_display_effect'] : '';
	$animation_step = $animated ? $atts['animate_on_display_step'] : '';

	$animated_on_hover = filter_var( $atts['animate_on_hover'], FILTER_VALIDATE_BOOLEAN );
	$hover_animation = $animated_on_hover ? $atts['animate_on_hover_effect'] : '';

	if( $animated ) {
		$classes[] = 'wow';
		$classes[] = $animation;
		$attributes[] = 'data-wow-delay="' . esc_attr( $animation_step ) .'s"';
	}
?>
<div class="shortcode-services-modern <?php echo implode(' ', $classes); ?>" id="shortcode-<?php echo esc_attr( $atts['el_id'] ); ?>" <?php echo implode( ' ', $attributes ); ?>>
	<div class="item-inside">

		<?php
			$header_bg = $atts['bg_image'] <> '' ? 'background-image: url(' . wp_get_attachment_url( $atts['bg_image'] ) . ');' : '';
		?>

		<header style="<?php echo $header_bg <> '' ? esc_attr( $header_bg ) : ''; ?>">

			<?php if( $atts['icon_type'] == 'fontawesome' ): ?>

			<div class="icon<?php if( $animated_on_hover ): ?> animate-on-hover<?php endif; ?>" data-hover-animation="<?php echo esc_attr($hover_animation); ?>">
				<i class="<?php echo esc_attr( $atts['icon_font'] ); ?>"></i>
			</div>

			<?php elseif( $atts['icon_type'] == 'custom' ): ?>

			<div class="icon<?php if( $animated_on_hover ): ?> animate-on-hover<?php endif; ?>" data-hover-animation="<?php echo esc_attr($hover_animation); ?>">
				<?php wplab_albedo_media::image_src( $atts['icon_image'] ); ?>
			</div>

			<?php endif; ?>

		</header>

		<div class="text">

			<?php if( $atts['category'] <> '' ): ?>
			<div class="category"><?php echo wp_kses_post( $atts['category'] ); ?></div>
			<?php endif; ?>

			<?php if( $atts['link'] <> '' ): ?>
			<a <?php if( filter_var( $atts['link_target'], FILTER_VALIDATE_BOOLEAN )): ?>target="_blank"<?php endif; ?> href="<?php echo esc_attr( $atts['link'] ); ?>">
			<?php endif; ?>

			<?php if( $atts['title'] <> '' ): ?>
			<h4><?php echo wp_kses_post( $atts['title'] ); ?></h4>
			<?php endif; ?>

			<?php if( $atts['link'] <> '' ): ?>
			</a>
			<?php endif; ?>

			<?php if( $atts['text'] <> '' ): ?>
			<?php
				$text = $atts['text'];
				$text = preg_replace("/\*+(.*)?/i","<ul><li>$1</li></ul>", $text);
				$text = preg_replace("/(\<\/ul\>\n(.*)\<ul\>*)+/","", $text);
			?>
			<div class="desc"><?php echo wp_kses_post( $text ); ?></div>
			<?php endif; ?>

			<?php if( $atts['link'] <> '' && filter_var( $atts['display_button'], FILTER_VALIDATE_BOOLEAN ) ): ?>
			<a <?php if( filter_var( $atts['link_target'], FILTER_VALIDATE_BOOLEAN )): ?>target="_blank"<?php endif; ?> href="<?php echo esc_attr( $atts['link'] ); ?>" class="button style-<?php echo esc_attr( $atts['button_style'] ); ?> size-medium"><?php echo wp_kses_post( $atts['button_title'] ); ?></a>
			<?php endif; ?>

		</div>

	</div>
</div>
