<?php
global $wplab_albedo_core;
/** unique id **/
$attributes[] = 'id="shortcode-' . $shortcode_id . '"';
$attributes[] = 'data-pagination="' . esc_attr( $atts['pagination'] ) . '"';
$attributes[] = 'data-loop="' . esc_attr( $atts['loop'] ) . '"';
$attributes[] = 'data-mousewheel="' . esc_attr( $atts['mousewheel'] ) . '"';

if( filter_var( $atts['autoplay'], FILTER_VALIDATE_BOOLEAN ) ) {
  $attributes[] = 'data-autoplay="' . esc_attr( $atts['autoplay_speed'] ) . '"';
  $attributes[] = 'data-autoplay-stop-on-last="' . esc_attr( $atts['autoplay_stop_on_last'] ) . '"';
  $attributes[] = 'data-autoplay-disable-on-interaction="' . esc_attr( $atts['autoplay_disable_on_interaction'] ) . '"';
}

$terms = in_array( $atts['query_type'], array('only', 'except') ) ? $atts['cats'] : '';

$items = $wplab_albedo_core->model('post')->get( array(
  'post_type' => 'media_slides',
  'type' => $atts['query_type'],
  'posts_per_page' => absint( $atts['posts_per_page'] ),
  'order' => $atts['order_by'],
  'sort' => $atts['sort_by'],
  'tax_name' => 'media_slides_category',
  'term_field' => 'slug',
  'terms' => $terms
) );

?>

<div class="shortcode-presentation <?php echo implode(' ', $classes); ?>" <?php echo implode( ' ', $attributes ); ?>>
	<!-- Slider main container -->
	<div class="swiper-container">

    <!-- Additional required wrapper -->
    <div class="swiper-wrapper">

      <?php while ( $items->have_posts() ): $items->the_post(); ?>

      <div class="swiper-slide">

        <div class="container_fluid">
          <div class="row">
            <?php
              $video_url = fw_get_db_post_option( get_the_ID(), 'video_url' );
              $content_type = $video_url <> '' ? 'video' : 'image';
              $cover_img = get_the_post_thumbnail_url( get_the_ID(), 'full' );
              $href_url = $content_type == 'image' ? $cover_img : $video_url;
            ?>

            <div class="col-md-6 col content-type-<?php echo esc_attr( $content_type ); ?> col-thumb" style="background-image: url( <?php echo esc_attr( $cover_img ); ?> )">

              <div class="overlay bg-color-<?php echo esc_attr( $atts['accent_color'] ); ?>"></div>

              <?php if( $href_url <> '' ): ?>
              <a href="<?php echo esc_attr( $href_url ); ?>" class="media-svg-lightbox" data-src="<?php echo esc_attr( $href_url ); ?>"></a>
              <?php endif; ?>

            </div>
            <div class="col-md-6 col col-text">

              <?php
                $title = get_the_title();
                $text = get_the_content();
              ?>

              <?php if( $title <> '' ): ?>
              <h2><?php echo wp_kses_post( $title ); ?></h2>
              <?php endif; ?>

              <?php if( $text <> '' ): ?>
              <div class="text"><?php echo wpautop( $text ); ?></div>
              <?php endif; ?>

              <?php
                $button_title = fw_get_db_post_option( get_the_ID(), 'display_button/yes/button_text' );
                if( filter_var( fw_get_db_post_option( get_the_ID(), 'display_button/enabled' ), FILTER_VALIDATE_BOOLEAN ) && $button_title <> '' ): ?>
              <a target="_blank" href="<?php echo esc_attr( fw_get_db_post_option( get_the_ID(), 'display_button/yes/button_url' ) ); ?>" class="button style-<?php echo esc_attr( fw_get_db_post_option( get_the_ID(), 'display_button/yes/button_style' ) ); ?> size-medium"><?php echo wp_kses_post( $button_title ); ?></a>
              <?php endif; ?>

            </div>

          </div>
        </div>

      </div>

      <?php endwhile; wp_reset_postdata(); ?>

    </div>

  </div>

  <?php if( filter_var( $atts['pagination'], FILTER_VALIDATE_BOOLEAN ) ): ?>
  <!-- If we need pagination -->
  <div class="swiper-pagination"></div>
  <?php endif; ?>

</div>
