<?php

	$attributes[] = 'id="shortcode-' . $id . '"';

  $attributes[] = 'data-effect="' . esc_attr( $atts['effect'] ) . '"';
  $attributes[] = 'data-pagination="' . esc_attr( $atts['pagination'] ) . '"';
  $attributes[] = 'data-loop="' . esc_attr( $atts['loop'] ) . '"';

  $attributes[] = 'data-slides-num="' . absint( $atts['items_big'] ) . '"';
  $attributes[] = 'data-slides-medium-num="' . absint( $atts['items_medium'] ) . '"';
  $attributes[] = 'data-slides-small-num="' . absint( $atts['items_small'] ) . '"';

  if( filter_var( $atts['autoplay'], FILTER_VALIDATE_BOOLEAN ) ) {
    $attributes[] = 'data-autoplay="' . esc_attr( $atts['autoplay_speed'] ) . '"';
    $attributes[] = 'data-autoplay-stop-on-last="' . esc_attr( $atts['autoplay_stop_on_last'] ) . '"';
    $attributes[] = 'data-autoplay-disable-on-interaction="' . esc_attr( $atts['autoplay_disable_on_interaction'] ) . '"';
  }

	$classes[] = 'style-carousel';

	if( filter_var( $atts['hover_opacity_effect'], FILTER_VALIDATE_BOOLEAN ) ) {
		$classes[] = 'hover-effect';
	}

  $images = $atts['images'] <> '' ? explode( ',', $atts['images'] ) : array();

?>
<div class="logos-carousel <?php echo implode(' ', $classes); ?>" <?php echo implode( ' ', $attributes ); ?>>
  <!-- Slider main container -->
  <div class="swiper-container">

    <!-- Additional required wrapper -->
    <div class="swiper-wrapper">

      <?php if( count( $images ) > 0 ): foreach( $images as $image ): ?>
      <div class="item swiper-slide">
        <?php echo wplab_albedo_media::image( wp_get_attachment_url( $image ), null, null, true, false, false, false ); ?>
      </div>
    <?php endforeach; endif; ?>
    </div>

  </div>

  <?php if( filter_var( $atts['pagination'], FILTER_VALIDATE_BOOLEAN ) ): ?>
  <!-- If we need pagination -->
  <div class="swiper-pagination"></div>
  <?php endif; ?>
</div>
