<?php

vc_map( array(
  'name' => esc_html__( 'Horizontal Timeline', 'wplab-albedo-core-plugin' ),
	'base' => 'albedo_timeline_h',
  'icon' => $this->plugin_uri . '/assets/shortcode_icons/horizontal-timeline.png',
  'front_enqueue_js' => $this->plugin_uri . '/shortcodes/timeline-h/js/vc.js',
	'category' => esc_html__( 'Content Elements', 'wplab-albedo-core-plugin' ),
	'description' => esc_html__( 'Add Horizontal Timeline', 'wplab-albedo-core-plugin' ),
	'params' => array(

    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Query type', 'wplab-albedo-core-plugin'),
      'param_name' => 'query_type',
      'admin_label' => true,
      'value' => array(
        esc_html__('All Events', 'wplab-albedo-core-plugin') => 'all',
        esc_html__('Events only from selected categories', 'wplab-albedo-core-plugin') => 'only',
        esc_html__('Events except categories', 'wplab-albedo-core-plugin') => 'except',
      ),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Posts count', 'wplab-albedo-core-plugin' ),
      'param_name' => 'posts_per_page',
      'value' => '20',
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Categories', 'wplab-albedo-core-plugin' ),
      'param_name' => 'cats',
      'value' => '',
      'admin_label' => true,
      'dependency' => array(
        'element' => 'query_type',
        'value' => array( 'only', 'except' ),
      ),
      'description' => esc_html__( 'Type here categories slugs, e.g. my-category', 'wplab-albedo-core-plugin' ),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Ordering method', 'wplab-albedo-core-plugin'),
      'param_name' => 'order_by',
      'value' => array(
        esc_html__('Date', 'wplab-albedo-core-plugin') => 'date',
        esc_html__('ID', 'wplab-albedo-core-plugin') => 'ID',
        esc_html__('Modified date', 'wplab-albedo-core-plugin') => 'modified',
        esc_html__('Title', 'wplab-albedo-core-plugin') => 'title',
        esc_html__('Random', 'wplab-albedo-core-plugin') => 'rand',
        esc_html__('Menu', 'wplab-albedo-core-plugin') => 'menu_order',
      ),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Sorting method', 'wplab-albedo-core-plugin'),
      'param_name' => 'sort_by',
      'value' => array(
        esc_html__('Descending', 'wplab-albedo-core-plugin') => 'DESC',
        esc_html__('Ascending', 'wplab-albedo-core-plugin') => 'ASC',
      ),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Minimum distance between items', 'wplab-albedo-core-plugin' ),
      'param_name' => 'min_distance',
      'value' => '80',
      'save_always' => true,
    ),
    array(
      'type' => 'el_id',
      'heading' => esc_html__( 'Element ID', 'wplab-albedo-core-plugin' ),
      'param_name' => 'el_id',
      'settings' => array(
        'auto_generate' => true,
      ),
      'description' => esc_html__( 'Unique identifier of this element', 'wplab-albedo-core-plugin' ),
    ),

  )
));
