<?php

vc_map( array(
  'name' => esc_html__( 'Team Members', 'wplab-albedo-core-plugin' ),
	'base' => 'albedo_team_members',
  'icon' => $this->plugin_uri . '/assets/shortcode_icons/team-members.png',
  'front_enqueue_js' => $this->plugin_uri . '/shortcodes/team-members/js/vc.js',
	'category' => esc_html__( 'Team', 'wplab-albedo-core-plugin' ),
	'description' => esc_html__( 'Add team members', 'wplab-albedo-core-plugin' ),
	'params' => array(

    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Query type', 'wplab-albedo-core-plugin'),
      'param_name' => 'query_type',
      'value' => array(
        esc_html__('All Team Members', 'wplab-albedo-core-plugin') => 'all',
        esc_html__('Team Members only from selected categories', 'wplab-albedo-core-plugin') => 'only',
        esc_html__('Team Members except categories', 'wplab-albedo-core-plugin') => 'except',
      ),
      'group' => esc_html__('Query', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Slides count', 'wplab-albedo-core-plugin' ),
      'param_name' => 'posts_per_page',
      'value' => '10',
      'group' => esc_html__('Query', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Categories', 'wplab-albedo-core-plugin' ),
      'param_name' => 'cats',
      'value' => '',
      'dependency' => array(
        'element' => 'query_type',
        'value' => array( 'only', 'except' ),
      ),
      'description' => esc_html__( 'Type here categories slugs, e.g. my-category', 'wplab-albedo-core-plugin' ),
      'group' => esc_html__('Query', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Ordering method', 'wplab-albedo-core-plugin'),
      'param_name' => 'order_by',
      'value' => array(
        esc_html__('Date', 'wplab-albedo-core-plugin') => 'date',
        esc_html__('ID', 'wplab-albedo-core-plugin') => 'ID',
        esc_html__('Modified date', 'wplab-albedo-core-plugin') => 'modified',
        esc_html__('Title', 'wplab-albedo-core-plugin') => 'title',
        esc_html__('Random', 'wplab-albedo-core-plugin') => 'rand',
        esc_html__('Menu', 'wplab-albedo-core-plugin') => 'menu_order',
      ),
      'group' => esc_html__('Query', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Sorting method', 'wplab-albedo-core-plugin'),
      'param_name' => 'sort_by',
      'value' => array(
        esc_html__('Descending', 'wplab-albedo-core-plugin') => 'DESC',
        esc_html__('Ascending', 'wplab-albedo-core-plugin') => 'ASC',
      ),
      'group' => esc_html__('Query', 'wplab-albedo-core-plugin'),
    ),

    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Columns', 'wplab-albedo-core-plugin'),
      'param_name' => 'cols',
      'save_always' => true,
      'value' => array(
        '4' => '4',
        '3' => '3',
        '2' => '2',
        '1' => '1',
      ),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'el_id',
      'heading' => esc_html__( 'Element ID', 'wplab-albedo-core-plugin' ),
      'param_name' => 'el_id',
      'settings' => array(
        'auto_generate' => true,
      ),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
      'description' => esc_html__( 'Unique identifier of this element', 'wplab-albedo-core-plugin' ),
    ),


    /**
     * Animation tab
    **/
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Animate elements on display', 'wplab-albedo-core-plugin' ),
      'param_name' => 'animate_on_display',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('Animation', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Animation Effect', 'wplab-albedo-core-plugin'),
      'param_name' => 'animate_on_display_effect',
      'save_always' => true,
      'value' => $this->cfg['animations'],
      'dependency' => array(
  			'element' => 'animate_on_display',
  			'not_empty' => true,
  		),
      'group' => esc_html__('Animation', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Time step', 'wplab-albedo-core-plugin' ),
      'param_name' => 'animate_on_display_step',
      'value' => '0.2',
      'save_always' => true,
      'dependency' => array(
  			'element' => 'animate_on_display',
  			'not_empty' => true,
  		),
      'group' => esc_html__('Animation', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Animate elements on hover', 'wplab-albedo-core-plugin' ),
      'param_name' => 'animate_on_hover',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('Animation', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Animation Effect', 'wplab-albedo-core-plugin'),
      'param_name' => 'animate_on_hover_effect',
      'save_always' => true,
      'value' => $this->cfg['animations'],
      'dependency' => array(
  			'element' => 'animate_on_hover',
  			'not_empty' => true,
  		),
      'group' => esc_html__('Animation', 'wplab-albedo-core-plugin'),
    ),



  )
));

vc_map( array(
  'name' => esc_html__( 'Team Member', 'wplab-albedo-core-plugin' ),
	'base' => 'albedo_team_members_single',
  'icon' => $this->plugin_uri . '/assets/shortcode_icons/team-members.png',
  'content_element' => true,
  'as_child' => array( 'only' => 'albedo_team_members' ),
	'params' => array(

    array(
      'type' => 'attach_image',
      'heading' => esc_html__('Photo', 'wplab-albedo-core-plugin'),
      'param_name' => 'photo',
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Name', 'wplab-albedo-core-plugin' ),
      'param_name' => 'name',
      'value' => '',
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Position', 'wplab-albedo-core-plugin' ),
      'param_name' => 'position',
      'value' => '',
    ),
    array(
      'type' => 'textarea',
      'heading' => esc_html__( 'Free text', 'wplab-albedo-core-plugin' ),
      'param_name' => 'text',
      'value' => '',
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Job vacancy', 'wplab-albedo-core-plugin' ),
      'param_name' => 'is_vacancy',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Display button', 'wplab-albedo-core-plugin' ),
      'param_name' => 'display_button',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Button title', 'wplab-albedo-core-plugin' ),
      'param_name' => 'button_title',
      'value' => '',
      'dependency' => array(
  			'element' => 'display_button',
  			'not_empty' => true,
  		),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Button URL', 'wplab-albedo-core-plugin' ),
      'param_name' => 'button_url',
      'value' => '',
      'dependency' => array(
  			'element' => 'display_button',
  			'not_empty' => true,
  		),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Button style', 'wplab-albedo-core-plugin'),
      'description' => esc_html__('Here you can choose pre-defined styles for a button', 'wplab-albedo-core-plugin'),
      'param_name' => 'button_style',
      'save_always' => true,
      'value' => $this->cfg['button_styles'],
      'dependency' => array(
  			'element' => 'display_button',
  			'not_empty' => true,
  		),
    ),

  ) + $this->cfg['social_profiles']
));
