(function($){

	"use strict";

	window.albedo_tabs_init = function() {
		$('.theme-tabs').each( function() {

			var $elem = $(this),
      $tabs = $elem.find('.tab_content'),
      $tabsContainer = $elem.find('.tabs');

			$tabs.hide();
			$elem.find('.tab_content:first').show();

      // build desktop navigation
      $elem.find('.nav-mobile, .nav-desktop').remove();
      $elem.prepend( '<nav class="nav-mobile"><select></select></nav><nav class="nav-desktop"></nav>');
      $tabs.each( function( index ){

        var $tabElem = $(this),
        tabTitle = $.trim( $tabElem.data('tab-title') );

        $tabElem.attr('class',
         function(i, c){
            return c.replace(/(^|\s)tab_number_\S+/g, '');
         });

        $tabElem.addClass('tab_number_' + index )

        $elem.find('.nav-mobile select').append( $('<option>', {
          value: index,
          text: tabTitle
        }));

        $elem.find('.nav-desktop').append( '<a href="javascript:;" class="a-tab-desktop" data-item="' + index + '">' + tabTitle + '</a>');

      } );

      $tabsContainer.find('.nav-mobile select').dropdown({
        mobile: true
      });

			$elem.find('.nav-desktop a.a-tab-desktop:first, .tab_content:first').addClass('open');

			$elem.find('.nav-desktop a.a-tab-desktop').off('click').on('click', function() {

				var tabNum = $(this).data('item');
				$elem.find('.nav-desktop a.a-tab-desktop, .tab_content').removeClass('open');
				$(this).addClass('open');

				$elem.find('.nav-mobile select').val( tabNum ).trigger('change');

			});

			$elem.find('.nav-mobile select').off('change').on('change', function() {

				var tabNum = $(this).val();
				$elem.find('nav > a, .tab_content').removeClass('open');
				$elem.find('nav > a').eq( tabNum ).addClass('open');
				$elem.find('.tab_content').hide();

				var $content = $elem.find( '.tab_number_' + tabNum );
				if( $content.is(':visible') == false ) {
					$content.fadeIn();
				}

			});

		});
	}

	window.albedo_tabs_resize = function() {
		$('.theme-tabs').each( function() {
			var $elem = $(this),
			responsiveBreak = $elem.data('responsive-break');

			responsiveBreak = responsiveBreak == '' ? 767 : responsiveBreak;

			if( $(window).width() < responsiveBreak ) {
				$elem.addClass('mobile');
				$elem.find('.tab-content-image, .nav-desktop').hide();
				$elem.find('.nav-mobile').show();
			} else {
				$elem.removeClass('mobile');
				$elem.find('.tab-content-image, .nav-desktop').show();
				$elem.find('.nav-mobile').hide();
			}

		});
	}

	// Tabs shortcode
	window.albedo_tabs_init();
	window.albedo_tabs_resize();

	$(window).resize( function() {
		window.albedo_tabs_resize();
	});

})( window.jQuery );
