<?php

/**
 * Modify default Row Shortcode
**/

// Remove some of default options

vc_remove_param( 'vc_row', 'video_bg' );
vc_remove_param( 'vc_row', 'video_bg_parallax' );
vc_remove_param( 'vc_row', 'video_bg_url' );
vc_remove_param( 'vc_row', 'parallax_speed_video' );
vc_remove_param( 'vc_row', 'parallax' );
vc_remove_param( 'vc_row', 'parallax_image' );
vc_remove_param( 'vc_row', 'parallax_speed_bg' );
//vc_remove_param( 'vc_row', 'full_width' );
vc_remove_param( 'vc_row', 'full_height' );
vc_remove_param( 'vc_row', 'equal_height' );
vc_remove_param( 'vc_row', 'content_placement' );
vc_remove_param( 'vc_row', 'columns_placement' );
//vc_remove_param( 'vc_row', 'gap' );
vc_remove_param( 'vc_row', 'css' );

vc_map_update( 'vc_row', array(
  'front_enqueue_js' => $this->plugin_uri . '/shortcodes/row/js/vc.js',
));

vc_add_params( 'vc_row', array(

  /*
    General Tab
  */
  array(
    'type' => 'el_id',
    'heading' => esc_html__( 'Anchor (row ID)', 'wplab-albedo-core-plugin' ),
    'param_name' => 'el_id',
    'settings' => array(
      'auto_generate' => true,
    ),
    'description' => esc_html__( 'Unique identifier of this row', 'wplab-albedo-core-plugin' ),
  ),
  array(
    'type' => 'dropdown',
    'heading' => esc_html__('Row style', 'wplab-albedo-core-plugin'),
    'param_name' => 'section_style',
    'value' => array(
      esc_html__('Default', 'wplab-albedo-core-plugin') => '',
      esc_html__('Boxed style', 'wplab-albedo-core-plugin') => 'boxed',
      esc_html__('Boxed style, rounded corners', 'wplab-albedo-core-plugin') => 'boxed_rounded',
      esc_html__('Layers style (layers on top)', 'wplab-albedo-core-plugin') => 'bg-layers bg-layers-pos-top',
      esc_html__('Layers style (layers on bottom)', 'wplab-albedo-core-plugin') => 'bg-layers bg-layers-pos-bottom',
    ),
  ),
  array(
    'type' => 'checkbox',
    'heading' => esc_html__( 'Full height', 'wplab-albedo-core-plugin' ),
    'param_name' => 'full_height',
    'description' => esc_html__( 'makes section height equal screen height', 'wplab-albedo-core-plugin' ),
    'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
  ),
  array(
    'type' => 'checkbox',
    'heading' => esc_html__( 'Center content inside', 'wplab-albedo-core-plugin' ),
    'param_name' => 'center_content',
    'dependency' => array(
			'element' => 'full_height',
			'not_empty' => true,
		),
    'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
  ),
  array(
    'type' => 'checkbox',
    'heading' => esc_html__( 'Relative position', 'wplab-albedo-core-plugin' ),
    'param_name' => 'is_relative',
    'description' => esc_html__( 'adds position: relative; CSS property to current row', 'wplab-albedo-core-plugin' ),
    'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
  ),
  array(
    'type' => 'textfield',
    'heading' => esc_html__( 'Z-index', 'wplab-albedo-core-plugin' ),
    'param_name' => 'z_index',
    'value' => '',
    'description' => esc_html__( 'For example: 100. Can be used with relative position option', 'wplab-albedo-core-plugin' ),
  ),

  /*
    Background tab
  */
  array(
    'type' => 'dropdown',
    'heading' => esc_html__('Background type', 'wplab-albedo-core-plugin'),
    'param_name' => 'bg_css_type',
    'value' => array(
      esc_html__('Background color', 'wplab-albedo-core-plugin') => 'color',
      esc_html__('Gradient background', 'wplab-albedo-core-plugin') => 'gradient',
      esc_html__('Custom gradient background', 'wplab-albedo-core-plugin') => 'custom_gradient',
    ),
    'group' => esc_html__('Background', 'wplab-albedo-core-plugin'),
  ),
  array(
		'type' => 'colorpicker',
		'heading' => esc_html__( 'Background Color', 'wplab-albedo-core-plugin' ),
		'param_name' => 'background_color',
		'description' => esc_html__( 'Select the custom background color', 'js_composer' ),
		'value' => '',
		'dependency' => array(
			'element' => 'bg_css_type',
			'value' => array( 'color' ),
		),
		'group' => esc_html__('Background', 'wplab-albedo-core-plugin'),
	),
  array(
		'type' => 'colorpicker',
		'heading' => esc_html__( 'Gradient background from', 'wplab-albedo-core-plugin' ),
		'param_name' => 'background_gradient_primary',
		'value' => '#ffffff',
		'dependency' => array(
			'element' => 'bg_css_type',
			'value' => array( 'gradient', 'custom_gradient' ),
		),
		'group' => esc_html__('Background', 'wplab-albedo-core-plugin'),
	),
  array(
		'type' => 'colorpicker',
		'heading' => esc_html__( 'Gradient background to', 'wplab-albedo-core-plugin' ),
		'param_name' => 'background_gradient_secondary',
		'value' => '#eeeeee',
		'dependency' => array(
			'element' => 'bg_css_type',
			'value' => array( 'gradient', 'custom_gradient' ),
		),
		'group' => esc_html__('Background', 'wplab-albedo-core-plugin'),
	),
  array(
    'type' => 'dropdown',
    'heading' => esc_html__('Gradient direction', 'wplab-albedo-core-plugin'),
    'param_name' => 'background_gradient_direction',
    'value' => array(
      esc_html__('Linear, From Top to Bottom', 'wplab-albedo-core-plugin') => 'top_bottom',
      esc_html__('Linear, From Left to Right', 'wplab-albedo-core-plugin') => 'left_right',
      esc_html__('Linear, From Left Top to Right Bottom', 'wplab-albedo-core-plugin') => 'top_left_bottom_right',
      esc_html__('Linear, From Left Bottom to Right Top', 'wplab-albedo-core-plugin') => 'bottom_left_top_right',
      esc_html__('Radial', 'wplab-albedo-core-plugin') => 'radial',
    ),
    'dependency' => array(
			'element' => 'bg_css_type',
			'value' => array( 'gradient' ),
		),
    'group' => esc_html__('Background', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'dropdown',
    'heading' => esc_html__('Gradient direction', 'wplab-albedo-core-plugin'),
    'param_name' => 'background_custom_gradient_style',
    'value' => array(
      esc_html__('Linear', 'wplab-albedo-core-plugin') => 'linear',
      esc_html__('Radial', 'wplab-albedo-core-plugin') => 'radial',
    ),
    'dependency' => array(
			'element' => 'bg_css_type',
			'value' => array( 'custom_gradient' ),
		),
    'group' => esc_html__('Background', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'dropdown',
    'heading' => esc_html__('Gradient direction', 'wplab-albedo-core-plugin'),
    'param_name' => 'background_custom_gradient_linear_pos',
    'value' => array(
      esc_html__('To bottom right', 'wplab-albedo-core-plugin') => 'top left',
      esc_html__('To bottom', 'wplab-albedo-core-plugin') => 'top',
      esc_html__('To bottom left', 'wplab-albedo-core-plugin') => 'top right',
      esc_html__('To right', 'wplab-albedo-core-plugin') => 'left',
      esc_html__('To left', 'wplab-albedo-core-plugin') => 'right',
      esc_html__('To top right', 'wplab-albedo-core-plugin') => 'bottom left',
      esc_html__('To top', 'wplab-albedo-core-plugin') => 'bottom',
      esc_html__('To top left', 'wplab-albedo-core-plugin') => 'bottom right',
    ),
    'dependency' => array(
			'element' => 'background_custom_gradient_style',
			'value' => array( 'linear' ),
		),
    'group' => esc_html__('Background', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'dropdown',
    'heading' => esc_html__('Gradient position', 'wplab-albedo-core-plugin'),
    'param_name' => 'background_custom_gradient_radial_pos',
    'value' => array(
      esc_html__('Top Left', 'wplab-albedo-core-plugin') => 'left top',
      esc_html__('Top Center', 'wplab-albedo-core-plugin') => 'center top',
      esc_html__('Top Right', 'wplab-albedo-core-plugin') => 'right top',
      esc_html__('Middle Left', 'wplab-albedo-core-plugin') => 'left center',
      esc_html__('Middle Center', 'wplab-albedo-core-plugin') => 'center',
      esc_html__('Middle Right', 'wplab-albedo-core-plugin') => 'right center',
      esc_html__('Bottom Left', 'wplab-albedo-core-plugin') => 'left bottom',
      esc_html__('Bottom Right', 'wplab-albedo-core-plugin') => 'right bottom',
    ),
    'dependency' => array(
			'element' => 'background_custom_gradient_style',
			'value' => array( 'radial' ),
		),
    'group' => esc_html__('Background', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'dropdown',
    'heading' => esc_html__('Gradient size', 'wplab-albedo-core-plugin'),
    'param_name' => 'background_custom_gradient_radial_size',
    'value' => array(
      esc_html__('Closest Side', 'wplab-albedo-core-plugin') => 'closest-side',
      esc_html__('Closest Corner', 'wplab-albedo-core-plugin') => 'closest-corner',
      esc_html__('Farthest side', 'wplab-albedo-core-plugin') => 'farthest-side',
      esc_html__('Farthest corner', 'wplab-albedo-core-plugin') => 'farthest-corner',
    ),
    'dependency' => array(
			'element' => 'background_custom_gradient_style',
			'value' => array( 'radial' ),
		),
    'group' => esc_html__('Background', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'textfield',
    'heading' => esc_html__( 'Gradient start position', 'wplab-albedo-core-plugin' ),
    'param_name' => 'custom_background_start_pos',
    'value' => '0',
    'dependency' => array(
			'element' => 'background_custom_gradient_style',
			'value' => array( 'linear', 'radial' ),
		),
    'group' => esc_html__('Background', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'textfield',
    'heading' => esc_html__( 'Gradient end position', 'wplab-albedo-core-plugin' ),
    'param_name' => 'custom_background_end_pos',
    'value' => '100',
    'dependency' => array(
			'element' => 'background_custom_gradient_style',
			'value' => array( 'linear', 'radial' ),
		),
    'group' => esc_html__('Background', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'attach_image',
    'heading' => esc_html__('Background Image', 'wplab-albedo-core-plugin'),
    'param_name' => 'background_image',
    'dependency' => array(
			'element' => 'bg_css_type',
			'value' => array( 'color' ),
		),
    'group' => esc_html__('Background', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'dropdown',
    'heading' => esc_html__('Background image position', 'wplab-albedo-core-plugin'),
    'param_name' => 'background_position',
    'value' => array(
      esc_html__('Left Top', 'wplab-albedo-core-plugin') => 'left top',
      esc_html__('Center Top', 'wplab-albedo-core-plugin') => 'center top',
      esc_html__('Right Top', 'wplab-albedo-core-plugin') => 'right top',
      esc_html__('Left Bottom', 'wplab-albedo-core-plugin') => 'left bottom',
      esc_html__('Center Bottom', 'wplab-albedo-core-plugin') => 'center bottom',
      esc_html__('Right Bottom', 'wplab-albedo-core-plugin') => 'right bottom',
      esc_html__('Left Center', 'wplab-albedo-core-plugin') => 'left center',
      esc_html__('Center Center', 'wplab-albedo-core-plugin') => 'center center',
      esc_html__('Right Center', 'wplab-albedo-core-plugin') => 'right center',
    ),
    'group' => esc_html__('Background', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'textfield',
    'heading' => esc_html__( 'Custom background image position', 'wplab-albedo-core-plugin' ),
    'param_name' => 'custom_background_position',
    'value' => '',
    'description' => esc_html__( 'here you can put own CSS background image position, e.g.: -5% bottom', 'wplab-albedo-core-plugin' ),
    'group' => esc_html__('Background', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'dropdown',
    'heading' => esc_html__('Background image repeat', 'wplab-albedo-core-plugin'),
    'param_name' => 'background_repeat',
    'value' => array(
      esc_html__('No repeat', 'wplab-albedo-core-plugin') => 'no-repeat',
      esc_html__('Repeat horizontally', 'wplab-albedo-core-plugin') => 'repeat-x',
      esc_html__('Repeat vertically', 'wplab-albedo-core-plugin') => 'repeat-y',
      esc_html__('Repeat horizontally and vertically', 'wplab-albedo-core-plugin') => 'repeat',
    ),
    'group' => esc_html__('Background', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'checkbox',
    'heading' => esc_html__( 'Lazy Load Background Image', 'wplab-albedo-core-plugin' ),
    'param_name' => 'background_lazy',
    'description' => esc_html__( 'If enabled, background image will be loaded through JavaScript after text content', 'wplab-albedo-core-plugin' ),
    'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
    'group' => esc_html__('Background', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'checkbox',
    'heading' => esc_html__( 'Cover Background Image', 'wplab-albedo-core-plugin' ),
    'param_name' => 'background_cover',
    'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
    'group' => esc_html__('Background', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'checkbox',
    'heading' => esc_html__( 'Fixed Background Image', 'wplab-albedo-core-plugin' ),
    'param_name' => 'background_fixed',
    'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
    'group' => esc_html__('Background', 'wplab-albedo-core-plugin'),
  ),

  /*
    Effects tab
  */
  array(
    'type' => 'dropdown',
    'heading' => esc_html__('Row Overlay', 'wplab-albedo-core-plugin'),
    'param_name' => 'overlay_effect',
    'value' => array(
      esc_html__('Disabled', 'wplab-albedo-core-plugin') => '',
      esc_html__('Solid color / Image', 'wplab-albedo-core-plugin') => 'solid',
    ),
    'group' => esc_html__('Effects', 'wplab-albedo-core-plugin'),
  ),
  array(
		'type' => 'colorpicker',
		'heading' => esc_html__( 'Overlay Color', 'wplab-albedo-core-plugin' ),
		'param_name' => 'background_overlay_color',
		'value' => '',
		'dependency' => array(
			'element' => 'overlay_effect',
			'value' => array( 'solid' ),
		),
		'group' => esc_html__('Effects', 'wplab-albedo-core-plugin'),
	),
  array(
    'type' => 'attach_image',
    'heading' => esc_html__('Overlay Image', 'wplab-albedo-core-plugin'),
    'param_name' => 'background_overlay_image',
    'dependency' => array(
			'element' => 'overlay_effect',
			'value' => array( 'solid' ),
		),
    'group' => esc_html__('Effects', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'dropdown',
    'heading' => esc_html__('Overlay image position', 'wplab-albedo-core-plugin'),
    'param_name' => 'background_overlay_image_pos',
    'value' => array(
      esc_html__('Left Top', 'wplab-albedo-core-plugin') => 'left top',
      esc_html__('Center Top', 'wplab-albedo-core-plugin') => 'center top',
      esc_html__('Right Top', 'wplab-albedo-core-plugin') => 'right top',
      esc_html__('Left Bottom', 'wplab-albedo-core-plugin') => 'left bottom',
      esc_html__('Center Bottom', 'wplab-albedo-core-plugin') => 'center bottom',
      esc_html__('Right Bottom', 'wplab-albedo-core-plugin') => 'right bottom',
      esc_html__('Left Center', 'wplab-albedo-core-plugin') => 'left center',
      esc_html__('Center Center', 'wplab-albedo-core-plugin') => 'center center',
      esc_html__('Right Center', 'wplab-albedo-core-plugin') => 'right center',
    ),
    'dependency' => array(
			'element' => 'overlay_effect',
			'value' => array( 'solid' ),
		),
    'group' => esc_html__('Effects', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'dropdown',
    'heading' => esc_html__('Overlay image repeat', 'wplab-albedo-core-plugin'),
    'param_name' => 'background_overlay_image_repeat',
    'value' => array(
      esc_html__('No repeat', 'wplab-albedo-core-plugin') => 'no-repeat',
      esc_html__('Repeat horizontally', 'wplab-albedo-core-plugin') => 'repeat-x',
      esc_html__('Repeat vertically', 'wplab-albedo-core-plugin') => 'repeat-y',
      esc_html__('Repeat horizontally and vertically', 'wplab-albedo-core-plugin') => 'repeat',
    ),
    'dependency' => array(
			'element' => 'overlay_effect',
			'value' => array( 'solid' ),
		),
    'group' => esc_html__('Effects', 'wplab-albedo-core-plugin'),
  ),

  array(
    'type' => 'dropdown',
    'heading' => esc_html__('Parallax Effects', 'wplab-albedo-core-plugin'),
    'param_name' => 'parallax_effects',
    'value' => array(
      esc_html__('No Parallax', 'wplab-albedo-core-plugin') => '',
      esc_html__('Parallax background', 'wplab-albedo-core-plugin') => 'parallax',
      esc_html__('Mouse Move Parallax background', 'wplab-albedo-core-plugin') => 'mouse_parallax',
      esc_html__('Scroll animation', 'wplab-albedo-core-plugin') => 'scroll_animation',
    ),
    'group' => esc_html__('Effects', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'textfield',
    'heading' => esc_html__( 'Parallax speed', 'wplab-albedo-core-plugin' ),
    'description' => esc_html__( 'Set a speed of parallax effect, e.g.: 1.5. Do not forget to assign some background image for this row.', 'wplab-albedo-core-plugin' ),
    'param_name' => 'parallax_speed',
    'value' => '0.4',
    'dependency' => array(
			'element' => 'parallax_effects',
			'value' => array( 'parallax' ),
		),
    'group' => esc_html__('Effects', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'checkbox',
    'heading' => esc_html__( 'Invert X', 'wplab-albedo-core-plugin' ),
    'param_name' => 'mouse_parallax_invert_x',
    'dependency' => array(
			'element' => 'parallax_effects',
			'value' => array( 'mouse_parallax' ),
		),
    'group' => esc_html__('Effects', 'wplab-albedo-core-plugin'),
    'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
  ),
  array(
    'type' => 'checkbox',
    'heading' => esc_html__( 'Invert Y', 'wplab-albedo-core-plugin' ),
    'param_name' => 'mouse_parallax_invert_y',
    'dependency' => array(
			'element' => 'parallax_effects',
			'value' => array( 'mouse_parallax' ),
		),
    'group' => esc_html__('Effects', 'wplab-albedo-core-plugin'),
    'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
  ),
  array(
    'type' => 'textfield',
    'heading' => esc_html__( 'Depth', 'wplab-albedo-core-plugin' ),
    'param_name' => 'mouse_parallax_depth',
    'value' => '0.2',
    'dependency' => array(
			'element' => 'parallax_effects',
			'value' => array( 'mouse_parallax' ),
		),
    'group' => esc_html__('Effects', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'textfield',
    'heading' => esc_html__( 'Limit X', 'wplab-albedo-core-plugin' ),
    'param_name' => 'mouse_parallax_limit_x',
    'value' => '10',
    'dependency' => array(
			'element' => 'parallax_effects',
			'value' => array( 'mouse_parallax' ),
		),
    'group' => esc_html__('Effects', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'textfield',
    'heading' => esc_html__( 'Limit Y', 'wplab-albedo-core-plugin' ),
    'param_name' => 'mouse_parallax_limit_y',
    'value' => '10',
    'dependency' => array(
			'element' => 'parallax_effects',
			'value' => array( 'mouse_parallax' ),
		),
    'group' => esc_html__('Effects', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'textfield',
    'heading' => esc_html__( 'Scalar X', 'wplab-albedo-core-plugin' ),
    'param_name' => 'mouse_parallax_scalar_x',
    'value' => '0',
    'dependency' => array(
			'element' => 'parallax_effects',
			'value' => array( 'mouse_parallax' ),
		),
    'group' => esc_html__('Effects', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'textfield',
    'heading' => esc_html__( 'Scalar Y', 'wplab-albedo-core-plugin' ),
    'param_name' => 'mouse_parallax_scalar_y',
    'value' => '0',
    'dependency' => array(
			'element' => 'parallax_effects',
			'value' => array( 'mouse_parallax' ),
		),
    'group' => esc_html__('Effects', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'textfield',
    'heading' => esc_html__( 'Friction X', 'wplab-albedo-core-plugin' ),
    'param_name' => 'mouse_parallax_friction_x',
    'value' => '0',
    'dependency' => array(
			'element' => 'parallax_effects',
			'value' => array( 'mouse_parallax' ),
		),
    'group' => esc_html__('Effects', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'textfield',
    'heading' => esc_html__( 'Friction Y', 'wplab-albedo-core-plugin' ),
    'param_name' => 'mouse_parallax_friction_y',
    'value' => '0',
    'dependency' => array(
			'element' => 'parallax_effects',
			'value' => array( 'mouse_parallax' ),
		),
    'group' => esc_html__('Effects', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'textfield',
    'heading' => esc_html__( 'Origin X', 'wplab-albedo-core-plugin' ),
    'param_name' => 'mouse_parallax_origin_x',
    'value' => '0',
    'dependency' => array(
			'element' => 'parallax_effects',
			'value' => array( 'mouse_parallax' ),
		),
    'group' => esc_html__('Effects', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'textfield',
    'heading' => esc_html__( 'Origin Y', 'wplab-albedo-core-plugin' ),
    'param_name' => 'mouse_parallax_origin_y',
    'value' => '0',
    'dependency' => array(
			'element' => 'parallax_effects',
			'value' => array( 'mouse_parallax' ),
		),
    'group' => esc_html__('Effects', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'textarea',
    'heading' => esc_html__( 'CSS code for start position', 'wplab-albedo-core-plugin' ),
    'description' => esc_html__( 'For example: background-position: 0% -100%;', 'wplab-albedo-core-plugin' ),
    'param_name' => 'scroll_animation_start_css',
    'value' => '',
    'dependency' => array(
			'element' => 'parallax_effects',
			'value' => array( 'scroll_animation' ),
		),
    'group' => esc_html__('Effects', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'textfield',
    'heading' => esc_html__( 'End position in pixels', 'wplab-albedo-core-plugin' ),
    'param_name' => 'mouse_parallax_end_pos',
    'value' => '500',
    'dependency' => array(
			'element' => 'parallax_effects',
			'value' => array( 'scroll_animation' ),
		),
    'group' => esc_html__('Effects', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'textarea',
    'heading' => esc_html__( 'CSS code for end position', 'wplab-albedo-core-plugin' ),
    'description' => esc_html__( 'For example: background-position: 0% 70%;', 'wplab-albedo-core-plugin' ),
    'param_name' => 'scroll_animation_end_css',
    'value' => '',
    'dependency' => array(
			'element' => 'parallax_effects',
			'value' => array( 'scroll_animation' ),
		),
    'group' => esc_html__('Effects', 'wplab-albedo-core-plugin'),
  ),


  array(
    'type' => 'dropdown',
    'heading' => esc_html__('Row Effects', 'wplab-albedo-core-plugin'),
    'param_name' => 'section_effects',
    'value' => array(
      esc_html__('No Effects', 'wplab-albedo-core-plugin') => '',
      esc_html__('YouTube Video Background', 'wplab-albedo-core-plugin') => 'video',
      esc_html__('Infinite Background Motion', 'wplab-albedo-core-plugin') => 'infinite_motion',
      esc_html__('Particle Groud Effect', 'wplab-albedo-core-plugin') => 'particleground',
      esc_html__('Particles Effect', 'wplab-albedo-core-plugin') => 'particles',
    ),
    'group' => esc_html__('Effects', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'textfield',
    'heading' => esc_html__( 'Video URL', 'wplab-albedo-core-plugin' ),
    'description' => esc_html__( 'Insert YouTube Video URL to embed this video as background', 'wplab-albedo-core-plugin' ),
    'param_name' => 'section_effect_video_url',
    'value' => '',
    'dependency' => array(
			'element' => 'section_effects',
			'value' => array( 'video' ),
		),
    'group' => esc_html__('Effects', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'attach_image',
    'heading' => esc_html__('Fallback image for mobile devices', 'wplab-albedo-core-plugin'),
    'description' => esc_html__('The path to the fallback image in case of background video on mobile devices', 'wplab-albedo-core-plugin'),
    'param_name' => 'section_effect_video_fallback_img',
    'dependency' => array(
			'element' => 'section_effects',
			'value' => array( 'video' ),
		),
    'group' => esc_html__('Effects', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'checkbox',
    'heading' => esc_html__( 'Mute video', 'wplab-albedo-core-plugin' ),
    'param_name' => 'section_effect_video_mute',
    'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
    'dependency' => array(
			'element' => 'section_effects',
			'value' => array( 'video' ),
		),
    'group' => esc_html__('Effects', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'textfield',
    'heading' => esc_html__( 'Video parallax speed', 'wplab-albedo-core-plugin' ),
    'description' => esc_html__( 'Example: 0.2 Leave it empty to disable parallax', 'wplab-albedo-core-plugin' ),
    'param_name' => 'section_effect_video_parallax_speed',
    'value' => '',
    'dependency' => array(
			'element' => 'section_effects',
			'value' => array( 'video' ),
		),
    'group' => esc_html__('Effects', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'textfield',
    'heading' => esc_html__( 'Animation speed', 'wplab-albedo-core-plugin' ),
    'description' => esc_html__( 'Set a speed of motion effect in seconds, e.g.: 10', 'wplab-albedo-core-plugin' ),
    'param_name' => 'section_effect_infinite_motion_speed',
    'value' => '10',
    'dependency' => array(
			'element' => 'section_effects',
			'value' => array( 'infinite_motion' ),
		),
    'group' => esc_html__('Effects', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'textfield',
    'heading' => esc_html__( 'Texture width', 'wplab-albedo-core-plugin' ),
    'description' => esc_html__( 'Specify background image width to avoid twitching, e.g.: 10', 'wplab-albedo-core-plugin' ),
    'param_name' => 'section_effect_infinite_motion_texture_width',
    'value' => '500',
    'dependency' => array(
			'element' => 'section_effects',
			'value' => array( 'infinite_motion' ),
		),
    'group' => esc_html__('Effects', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'dropdown',
    'heading' => esc_html__('Motion direction', 'wplab-albedo-core-plugin'),
    'param_name' => 'section_effect_infinite_motion_direction',
    'value' => array(
      esc_html__('From left to right', 'wplab-albedo-core-plugin') => 'right',
      esc_html__('From right to left', 'wplab-albedo-core-plugin') => 'left',
    ),
    'dependency' => array(
			'element' => 'section_effects',
			'value' => array( 'infinite_motion' ),
		),
    'group' => esc_html__('Effects', 'wplab-albedo-core-plugin'),
  ),
  array(
		'type' => 'colorpicker',
		'heading' => esc_html__( 'Dots Color', 'wplab-albedo-core-plugin' ),
		'param_name' => 'particleground_dots_color',
		'value' => '#fafafa',
		'dependency' => array(
			'element' => 'section_effects',
			'value' => array( 'particleground' ),
		),
		'group' => esc_html__('Effects', 'wplab-albedo-core-plugin'),
	),
  array(
		'type' => 'colorpicker',
		'heading' => esc_html__( 'Lines Color', 'wplab-albedo-core-plugin' ),
		'param_name' => 'particleground_lines_color',
		'value' => '#fcfcfc',
		'dependency' => array(
			'element' => 'section_effects',
			'value' => array( 'particleground' ),
		),
		'group' => esc_html__('Effects', 'wplab-albedo-core-plugin'),
	),
  array(
    'type' => 'textfield',
    'heading' => esc_html__( 'Dot size', 'wplab-albedo-core-plugin' ),
    'param_name' => 'particleground_dot_size',
    'value' => '7',
    'dependency' => array(
			'element' => 'section_effects',
			'value' => array( 'particleground' ),
		),
    'group' => esc_html__('Effects', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'checkbox',
    'heading' => esc_html__( 'Curved lines', 'wplab-albedo-core-plugin' ),
    'param_name' => 'particleground_curved_lines',
    'dependency' => array(
			'element' => 'section_effects',
			'value' => array( 'particleground' ),
		),
    'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
    'group' => esc_html__('Effects', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'checkbox',
    'heading' => esc_html__( 'Parallax effect', 'wplab-albedo-core-plugin' ),
    'param_name' => 'particleground_parallax',
    'dependency' => array(
			'element' => 'section_effects',
			'value' => array( 'particleground' ),
		),
    'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
    'group' => esc_html__('Effects', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'textfield',
    'heading' => esc_html__( 'Line width', 'wplab-albedo-core-plugin' ),
    'param_name' => 'particleground_line_width',
    'value' => '1',
    'dependency' => array(
			'element' => 'section_effects',
			'value' => array( 'particleground' ),
		),
    'group' => esc_html__('Effects', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'textfield',
    'heading' => esc_html__( 'Parallax Multiplier', 'wplab-albedo-core-plugin' ),
    'description' => esc_html__( 'The lower the number, the more extreme the parallax effect wil be.', 'wplab-albedo-core-plugin' ),
    'param_name' => 'particleground_parallax_multiplier',
    'value' => '5',
    'dependency' => array(
			'element' => 'section_effects',
			'value' => array( 'particleground' ),
		),
    'group' => esc_html__('Effects', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'textfield',
    'heading' => esc_html__( 'Proximity', 'wplab-albedo-core-plugin' ),
    'description' => esc_html__( 'How close two dots need to be, in pixels, before they join.', 'wplab-albedo-core-plugin' ),
    'param_name' => 'particleground_proximity',
    'value' => '100',
    'dependency' => array(
			'element' => 'section_effects',
			'value' => array( 'particleground' ),
		),
    'group' => esc_html__('Effects', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'textfield',
    'heading' => esc_html__( 'Minimum speed X', 'wplab-albedo-core-plugin' ),
    'param_name' => 'particleground_min_speed_x',
    'value' => '0.1',
    'dependency' => array(
			'element' => 'section_effects',
			'value' => array( 'particleground' ),
		),
    'group' => esc_html__('Effects', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'textfield',
    'heading' => esc_html__( 'Maximum speed X', 'wplab-albedo-core-plugin' ),
    'param_name' => 'particleground_max_speed_x',
    'value' => '0.7',
    'dependency' => array(
			'element' => 'section_effects',
			'value' => array( 'particleground' ),
		),
    'group' => esc_html__('Effects', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'textfield',
    'heading' => esc_html__( 'Minimum speed Y', 'wplab-albedo-core-plugin' ),
    'param_name' => 'particleground_min_speed_y',
    'value' => '0.1',
    'dependency' => array(
			'element' => 'section_effects',
			'value' => array( 'particleground' ),
		),
    'group' => esc_html__('Effects', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'textfield',
    'heading' => esc_html__( 'Maximum speed Y', 'wplab-albedo-core-plugin' ),
    'param_name' => 'particleground_max_speed_y',
    'value' => '0.7',
    'dependency' => array(
			'element' => 'section_effects',
			'value' => array( 'particleground' ),
		),
    'group' => esc_html__('Effects', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'dropdown',
    'heading' => esc_html__('Direction X', 'wplab-albedo-core-plugin'),
    'description' => esc_html__('Means that the dots will bounce off the edges of the canvas', 'wplab-albedo-core-plugin'),
    'param_name' => 'particleground_direction_x',
    'value' => array(
      esc_html__('Center', 'wplab-albedo-core-plugin') => 'center',
      esc_html__('Left', 'wplab-albedo-core-plugin') => 'left',
      esc_html__('Right', 'wplab-albedo-core-plugin') => 'right',
    ),
    'dependency' => array(
			'element' => 'section_effects',
			'value' => array( 'particleground' ),
		),
    'group' => esc_html__('Effects', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'dropdown',
    'heading' => esc_html__('Direction Y', 'wplab-albedo-core-plugin'),
    'description' => esc_html__('Means that the dots will bounce off the edges of the canvas', 'wplab-albedo-core-plugin'),
    'param_name' => 'particleground_direction_y',
    'value' => array(
      esc_html__('Center', 'wplab-albedo-core-plugin') => 'center',
      esc_html__('Left', 'wplab-albedo-core-plugin') => 'left',
      esc_html__('Right', 'wplab-albedo-core-plugin') => 'right',
    ),
    'dependency' => array(
			'element' => 'section_effects',
			'value' => array( 'particleground' ),
		),
    'group' => esc_html__('Effects', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'textfield',
    'heading' => esc_html__( 'Destiny', 'wplab-albedo-core-plugin' ),
    'param_name' => 'particleground_destiny',
    'value' => '1000',
    'dependency' => array(
			'element' => 'section_effects',
			'value' => array( 'particleground' ),
		),
    'group' => esc_html__('Effects', 'wplab-albedo-core-plugin'),
  ),

  array(
    'type' => 'textfield',
    'heading' => esc_html__( 'Particles number', 'wplab-albedo-core-plugin' ),
    'param_name' => 'particles_number',
    'value' => '80',
    'dependency' => array(
			'element' => 'section_effects',
			'value' => array( 'particles' ),
		),
    'group' => esc_html__('Effects', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'checkbox',
    'heading' => esc_html__( 'Enable density', 'wplab-albedo-core-plugin' ),
    'param_name' => 'particles_density',
    'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
    'dependency' => array(
			'element' => 'section_effects',
			'value' => array( 'particles' ),
		),
    'group' => esc_html__('Effects', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'textfield',
    'heading' => esc_html__( 'Density value', 'wplab-albedo-core-plugin' ),
    'param_name' => 'particles_density_value',
    'value' => '800',
    'dependency' => array(
      'element' => 'particles_density',
      'not_empty' => true,
    ),
    'group' => esc_html__('Effects', 'wplab-albedo-core-plugin'),
  ),
  array(
		'type' => 'colorpicker',
		'heading' => esc_html__( 'Particles color', 'wplab-albedo-core-plugin' ),
		'param_name' => 'particles_color',
		'value' => '#ffffff',
		'dependency' => array(
			'element' => 'section_effects',
			'value' => array( 'particles' ),
		),
		'group' => esc_html__('Effects', 'wplab-albedo-core-plugin'),
	),
  array(
    'type' => 'dropdown',
    'heading' => esc_html__('Shape type', 'wplab-albedo-core-plugin'),
    'param_name' => 'particles_shape_type',
    'value' => array(
      esc_html__('Circle', 'wplab-albedo-core-plugin') => 'circle',
      esc_html__('Edge', 'wplab-albedo-core-plugin') => 'edge',
      esc_html__('Triangle', 'wplab-albedo-core-plugin') => 'triangle',
      esc_html__('Polygon', 'wplab-albedo-core-plugin') => 'polygon',
      esc_html__('Star', 'wplab-albedo-core-plugin') => 'star',
    ),
    'dependency' => array(
			'element' => 'section_effects',
			'value' => array( 'particles' ),
		),
		'group' => esc_html__('Effects', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'textfield',
    'heading' => esc_html__( 'Shape stroke width', 'wplab-albedo-core-plugin' ),
    'param_name' => 'particles_shape_stroke_width',
    'value' => '0',
    'dependency' => array(
			'element' => 'section_effects',
			'value' => array( 'particles' ),
		),
    'group' => esc_html__('Effects', 'wplab-albedo-core-plugin'),
  ),
  array(
		'type' => 'colorpicker',
		'heading' => esc_html__( 'Shape stroke color', 'wplab-albedo-core-plugin' ),
		'param_name' => 'particles_shape_stroke_color',
		'value' => '#ffffff',
		'dependency' => array(
			'element' => 'section_effects',
			'value' => array( 'particles' ),
		),
		'group' => esc_html__('Effects', 'wplab-albedo-core-plugin'),
	),
  array(
    'type' => 'textfield',
    'heading' => esc_html__( 'Polygon sides', 'wplab-albedo-core-plugin' ),
    'param_name' => 'particles_polygon_sides',
    'value' => '5',
    'dependency' => array(
			'element' => 'section_effects',
			'value' => array( 'particles' ),
		),
    'group' => esc_html__('Effects', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'textfield',
    'heading' => esc_html__( 'Opacity', 'wplab-albedo-core-plugin' ),
    'param_name' => 'particles_opacity',
    'value' => '0.8',
    'dependency' => array(
			'element' => 'section_effects',
			'value' => array( 'particles' ),
		),
    'group' => esc_html__('Effects', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'checkbox',
    'heading' => esc_html__( 'Opacity random', 'wplab-albedo-core-plugin' ),
    'param_name' => 'particles_opacity_random',
    'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
    'dependency' => array(
			'element' => 'section_effects',
			'value' => array( 'particles' ),
		),
    'group' => esc_html__('Effects', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'checkbox',
    'heading' => esc_html__( 'Animate opacity', 'wplab-albedo-core-plugin' ),
    'param_name' => 'particles_animate_opacity',
    'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
    'dependency' => array(
			'element' => 'section_effects',
			'value' => array( 'particles' ),
		),
    'group' => esc_html__('Effects', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'textfield',
    'heading' => esc_html__( 'Animate speed', 'wplab-albedo-core-plugin' ),
    'param_name' => 'particles_animate_opacity_speed',
    'value' => '32',
    'dependency' => array(
      'element' => 'particles_animate_opacity',
      'not_empty' => true,
    ),
    'group' => esc_html__('Effects', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'textfield',
    'heading' => esc_html__( 'Opacity min', 'wplab-albedo-core-plugin' ),
    'param_name' => 'particles_animate_opacity_min',
    'value' => '0.1',
    'dependency' => array(
      'element' => 'particles_animate_opacity',
      'not_empty' => true,
    ),
    'group' => esc_html__('Effects', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'checkbox',
    'heading' => esc_html__( 'Sync animation', 'wplab-albedo-core-plugin' ),
    'param_name' => 'particles_animate_opacity_sync',
    'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
    'dependency' => array(
      'element' => 'particles_animate_opacity',
      'not_empty' => true,
    ),
    'group' => esc_html__('Effects', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'textfield',
    'heading' => esc_html__( 'Size', 'wplab-albedo-core-plugin' ),
    'param_name' => 'particles_size',
    'value' => '10',
    'dependency' => array(
			'element' => 'section_effects',
			'value' => array( 'particles' ),
		),
    'group' => esc_html__('Effects', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'checkbox',
    'heading' => esc_html__( 'Random size', 'wplab-albedo-core-plugin' ),
    'param_name' => 'particles_random_size',
    'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
    'dependency' => array(
			'element' => 'section_effects',
			'value' => array( 'particles' ),
		),
    'group' => esc_html__('Effects', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'checkbox',
    'heading' => esc_html__( 'Animate size', 'wplab-albedo-core-plugin' ),
    'param_name' => 'particles_animate_size',
    'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
    'dependency' => array(
			'element' => 'section_effects',
			'value' => array( 'particles' ),
		),
    'group' => esc_html__('Effects', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'textfield',
    'heading' => esc_html__( 'Animate size speed', 'wplab-albedo-core-plugin' ),
    'param_name' => 'particles_animate_size_speed',
    'value' => '32',
    'dependency' => array(
      'element' => 'particles_animate_size',
      'not_empty' => true,
    ),
    'group' => esc_html__('Effects', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'textfield',
    'heading' => esc_html__( 'Animate min size', 'wplab-albedo-core-plugin' ),
    'param_name' => 'particles_animate_size_min_size',
    'value' => '5',
    'dependency' => array(
      'element' => 'particles_animate_size',
      'not_empty' => true,
    ),
    'group' => esc_html__('Effects', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'checkbox',
    'heading' => esc_html__( 'Sync size animation', 'wplab-albedo-core-plugin' ),
    'param_name' => 'particles_animate_size_sync',
    'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
    'dependency' => array(
      'element' => 'particles_animate_size',
      'not_empty' => true,
    ),
    'group' => esc_html__('Effects', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'checkbox',
    'heading' => esc_html__( 'Enable linked lines', 'wplab-albedo-core-plugin' ),
    'param_name' => 'particles_enable_linked_lines',
    'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
    'dependency' => array(
			'element' => 'section_effects',
			'value' => array( 'particles' ),
		),
    'group' => esc_html__('Effects', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'textfield',
    'heading' => esc_html__( 'Distance', 'wplab-albedo-core-plugin' ),
    'param_name' => 'particles_linked_lines_distance',
    'value' => '150',
    'dependency' => array(
      'element' => 'particles_enable_linked_lines',
      'not_empty' => true,
    ),
    'group' => esc_html__('Effects', 'wplab-albedo-core-plugin'),
  ),
  array(
		'type' => 'colorpicker',
		'heading' => esc_html__( 'Color', 'wplab-albedo-core-plugin' ),
		'param_name' => 'particles_linked_lines_color',
		'value' => '',
    'dependency' => array(
      'element' => 'particles_enable_linked_lines',
      'not_empty' => true,
    ),
		'group' => esc_html__('Effects', 'wplab-albedo-core-plugin'),
	),
  array(
    'type' => 'textfield',
    'heading' => esc_html__( 'Opacity', 'wplab-albedo-core-plugin' ),
    'param_name' => 'particles_linked_lines_opacity',
    'value' => '0.5',
    'dependency' => array(
      'element' => 'particles_enable_linked_lines',
      'not_empty' => true,
    ),
    'group' => esc_html__('Effects', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'textfield',
    'heading' => esc_html__( 'Width', 'wplab-albedo-core-plugin' ),
    'param_name' => 'particles_linked_lines_width',
    'value' => '1.4',
    'dependency' => array(
      'element' => 'particles_enable_linked_lines',
      'not_empty' => true,
    ),
    'group' => esc_html__('Effects', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'checkbox',
    'heading' => esc_html__( 'Enable move', 'wplab-albedo-core-plugin' ),
    'param_name' => 'particles_enable_move',
    'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
    'dependency' => array(
			'element' => 'section_effects',
			'value' => array( 'particles' ),
		),
    'group' => esc_html__('Effects', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'dropdown',
    'heading' => esc_html__('Move direction', 'wplab-albedo-core-plugin'),
    'param_name' => 'particles_move_direction',
    'value' => array(
      esc_html__('None', 'wplab-albedo-core-plugin') => 'none',
      esc_html__('Top', 'wplab-albedo-core-plugin') => 'top',
      esc_html__('Top right', 'wplab-albedo-core-plugin') => 'top-right',
      esc_html__('Right', 'wplab-albedo-core-plugin') => 'right',
      esc_html__('Bottom right', 'wplab-albedo-core-plugin') => 'bottom-right',
      esc_html__('Bottom', 'wplab-albedo-core-plugin') => 'bottom',
      esc_html__('Bottom left', 'wplab-albedo-core-plugin') => 'bottom-left',
      esc_html__('Left', 'wplab-albedo-core-plugin') => 'left',
      esc_html__('Top left', 'wplab-albedo-core-plugin') => 'top-left',
    ),
    'dependency' => array(
      'element' => 'particles_enable_move',
      'not_empty' => true,
    ),
    'group' => esc_html__('Effects', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'checkbox',
    'heading' => esc_html__( 'Random', 'wplab-albedo-core-plugin' ),
    'param_name' => 'particles_move_random',
    'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
    'dependency' => array(
      'element' => 'particles_enable_move',
      'not_empty' => true,
    ),
    'group' => esc_html__('Effects', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'checkbox',
    'heading' => esc_html__( 'Straight', 'wplab-albedo-core-plugin' ),
    'param_name' => 'particles_move_straight',
    'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
    'dependency' => array(
      'element' => 'particles_enable_move',
      'not_empty' => true,
    ),
    'group' => esc_html__('Effects', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'textfield',
    'heading' => esc_html__( 'Speed', 'wplab-albedo-core-plugin' ),
    'param_name' => 'particles_move_speed',
    'value' => '8',
    'dependency' => array(
      'element' => 'particles_enable_move',
      'not_empty' => true,
    ),
    'group' => esc_html__('Effects', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'dropdown',
    'heading' => esc_html__('Out mode', 'wplab-albedo-core-plugin'),
    'param_name' => 'particles_move_out_mode',
    'value' => array(
      esc_html__('Out', 'wplab-albedo-core-plugin') => 'out',
      esc_html__('Bounce', 'wplab-albedo-core-plugin') => 'bounce',
    ),
    'dependency' => array(
      'element' => 'particles_enable_move',
      'not_empty' => true,
    ),
    'group' => esc_html__('Effects', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'checkbox',
    'heading' => esc_html__( 'Enable hover effect', 'wplab-albedo-core-plugin' ),
    'param_name' => 'particles_enable_hover_effect',
    'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
    'dependency' => array(
			'element' => 'section_effects',
			'value' => array( 'particles' ),
		),
    'group' => esc_html__('Effects', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'dropdown',
    'heading' => esc_html__('Hover mode', 'wplab-albedo-core-plugin'),
    'param_name' => 'particles_hover_mode',
    'value' => array(
      esc_html__('Grab', 'wplab-albedo-core-plugin') => 'grab',
      esc_html__('Bubble', 'wplab-albedo-core-plugin') => 'bubble',
      esc_html__('Repulse', 'wplab-albedo-core-plugin') => 'repulse',
    ),
    'dependency' => array(
      'element' => 'particles_enable_hover_effect',
      'not_empty' => true,
    ),
    'group' => esc_html__('Effects', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'checkbox',
    'heading' => esc_html__( 'Enable click effect', 'wplab-albedo-core-plugin' ),
    'param_name' => 'particles_enable_click_effect',
    'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
    'dependency' => array(
			'element' => 'section_effects',
			'value' => array( 'particles' ),
		),
    'group' => esc_html__('Effects', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'dropdown',
    'heading' => esc_html__('Click mode', 'wplab-albedo-core-plugin'),
    'param_name' => 'particles_click_effect_mode',
    'value' => array(
      esc_html__('Push', 'wplab-albedo-core-plugin') => 'push',
      esc_html__('Remove', 'wplab-albedo-core-plugin') => 'remove',
      esc_html__('Bubble', 'wplab-albedo-core-plugin') => 'bubble',
      esc_html__('Repulse', 'wplab-albedo-core-plugin') => 'repulse',
    ),
    'dependency' => array(
      'element' => 'particles_enable_click_effect',
      'not_empty' => true,
    ),
    'group' => esc_html__('Effects', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'textfield',
    'heading' => esc_html__( 'Grab distance', 'wplab-albedo-core-plugin' ),
    'param_name' => 'particles_grab_distance',
    'value' => '400',
    'dependency' => array(
			'element' => 'section_effects',
			'value' => array( 'particles' ),
		),
    'group' => esc_html__('Effects', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'textfield',
    'heading' => esc_html__( 'Grab opacity', 'wplab-albedo-core-plugin' ),
    'param_name' => 'particles_grab_opacity',
    'value' => '0.5',
    'dependency' => array(
			'element' => 'section_effects',
			'value' => array( 'particles' ),
		),
    'group' => esc_html__('Effects', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'textfield',
    'heading' => esc_html__( 'Bubble distance', 'wplab-albedo-core-plugin' ),
    'param_name' => 'particles_bubble_distance',
    'value' => '400',
    'dependency' => array(
			'element' => 'section_effects',
			'value' => array( 'particles' ),
		),
    'group' => esc_html__('Effects', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'textfield',
    'heading' => esc_html__( 'Bubble size', 'wplab-albedo-core-plugin' ),
    'param_name' => 'particles_bubble_size',
    'value' => '4',
    'dependency' => array(
			'element' => 'section_effects',
			'value' => array( 'particles' ),
		),
    'group' => esc_html__('Effects', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'textfield',
    'heading' => esc_html__( 'Bubble duration', 'wplab-albedo-core-plugin' ),
    'param_name' => 'particles_bubble_duration',
    'value' => '0.3',
    'dependency' => array(
			'element' => 'section_effects',
			'value' => array( 'particles' ),
		),
    'group' => esc_html__('Effects', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'textfield',
    'heading' => esc_html__( 'Bubble opacity', 'wplab-albedo-core-plugin' ),
    'param_name' => 'particles_bubble_opacity',
    'value' => '1',
    'dependency' => array(
			'element' => 'section_effects',
			'value' => array( 'particles' ),
		),
    'group' => esc_html__('Effects', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'textfield',
    'heading' => esc_html__( 'Bubble speed', 'wplab-albedo-core-plugin' ),
    'param_name' => 'particles_bubble_speed',
    'value' => '3',
    'dependency' => array(
			'element' => 'section_effects',
			'value' => array( 'particles' ),
		),
    'group' => esc_html__('Effects', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'textfield',
    'heading' => esc_html__( 'Repulse distance', 'wplab-albedo-core-plugin' ),
    'param_name' => 'particles_repulse_distance',
    'value' => '200',
    'dependency' => array(
			'element' => 'section_effects',
			'value' => array( 'particles' ),
		),
    'group' => esc_html__('Effects', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'textfield',
    'heading' => esc_html__( 'Repulse duration', 'wplab-albedo-core-plugin' ),
    'param_name' => 'particles_repulse_duration',
    'value' => '0.4',
    'dependency' => array(
			'element' => 'section_effects',
			'value' => array( 'particles' ),
		),
    'group' => esc_html__('Effects', 'wplab-albedo-core-plugin'),
  ),

  /*
    Styling tab
  */
  array(
		'type' => 'colorpicker',
		'heading' => esc_html__( 'Border color', 'wplab-albedo-core-plugin' ),
		'param_name' => 'border_color',
		'value' => '',
		'group' => esc_html__('Styling', 'wplab-albedo-core-plugin'),
	),
  array(
    'type' => 'dropdown',
    'heading' => esc_html__('Border Style', 'wplab-albedo-core-plugin'),
    'param_name' => 'border_style',
    'value' => array(
      esc_html__('None', 'wplab-albedo-core-plugin') => 'none',
      esc_html__('Hidden', 'wplab-albedo-core-plugin') => 'hidden',
      esc_html__('Dotted', 'wplab-albedo-core-plugin') => 'dotted',
      esc_html__('Dashed', 'wplab-albedo-core-plugin') => 'dashed',
      esc_html__('Solid', 'wplab-albedo-core-plugin') => 'solid',
      esc_html__('Double', 'wplab-albedo-core-plugin') => 'double',
      esc_html__('Groove', 'wplab-albedo-core-plugin') => 'groove',
      esc_html__('Ridge', 'wplab-albedo-core-plugin') => 'ridge',
    ),
    'group' => esc_html__('Styling', 'wplab-albedo-core-plugin'),
  ),
  array(
     'type' => 'albedo_sides_box',
     'heading' => esc_html__( 'Border width', 'wplab-albedo-core-plugin' ),
     'description' => esc_html__( 'Example: 10px 20% 20px 20%. Follow clockwise: top, right, bottom, left', 'wplab-albedo-core-plugin' ),
     'param_name' => 'border_width',
     'group' => esc_html__('Styling', 'wplab-albedo-core-plugin'),
  ),
  array(
     'type' => 'albedo_sides_box',
     'heading' => esc_html__( 'Border radius', 'wplab-albedo-core-plugin' ),
     'description' => esc_html__( 'Example: 10px 20% 20px 20%. Follow clockwise: top left, top right, bottom right, bottom left', 'wplab-albedo-core-plugin' ),
     'param_name' => 'border_radius',
     'group' => esc_html__('Styling', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'checkbox',
    'heading' => esc_html__( 'Add CSS box shadow', 'wplab-albedo-core-plugin' ),
    'param_name' => 'css_shadow',
    'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
    'group' => esc_html__('Styling', 'wplab-albedo-core-plugin'),
  ),
  array(
		'type' => 'colorpicker',
		'heading' => esc_html__( 'Shadow Color', 'wplab-albedo-core-plugin' ),
		'param_name' => 'css_shadow_color',
		'value' => '',
    'dependency' => array(
      'element' => 'css_shadow',
      'not_empty' => true,
    ),
		'group' => esc_html__('Styling', 'wplab-albedo-core-plugin'),
	),
  array(
    'type' => 'dropdown',
    'heading' => esc_html__('Shadow position', 'wplab-albedo-core-plugin'),
    'param_name' => 'css_shadow_position',
    'value' => array(
      esc_html__('Outside', 'wplab-albedo-core-plugin') => 'outside',
      esc_html__('Inside', 'wplab-albedo-core-plugin') => 'inside',
    ),
    'dependency' => array(
      'element' => 'css_shadow',
      'not_empty' => true,
    ),
    'group' => esc_html__('Styling', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'textfield',
    'heading' => esc_html__( 'Blur Radius', 'wplab-albedo-core-plugin' ),
    'param_name' => 'css_shadow_blur_radius',
    'value' => '0',
    'dependency' => array(
      'element' => 'css_shadow',
      'not_empty' => true,
    ),
    'group' => esc_html__('Styling', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'textfield',
    'heading' => esc_html__( 'Spread Radius', 'wplab-albedo-core-plugin' ),
    'param_name' => 'css_shadow_spread_radius',
    'value' => '0',
    'dependency' => array(
      'element' => 'css_shadow',
      'not_empty' => true,
    ),
    'group' => esc_html__('Styling', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'textfield',
    'heading' => esc_html__( 'Horizontal Length', 'wplab-albedo-core-plugin' ),
    'param_name' => 'css_shadow_h_len',
    'value' => '0',
    'dependency' => array(
      'element' => 'css_shadow',
      'not_empty' => true,
    ),
    'group' => esc_html__('Styling', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'textfield',
    'heading' => esc_html__( 'Vertical Length', 'wplab-albedo-core-plugin' ),
    'param_name' => 'css_shadow_v_len',
    'value' => '0',
    'dependency' => array(
      'element' => 'css_shadow',
      'not_empty' => true,
    ),
    'group' => esc_html__('Styling', 'wplab-albedo-core-plugin'),
  ),

  /*
    Margins tab
  */
  array(
     'type' => 'albedo_sides_box',
     'heading' => esc_html__( 'Row Margins', 'wplab-albedo-core-plugin' ),
     'description' => esc_html__( 'Example: 10px 20% 20px 20%. Follow clockwise: top, right, bottom, left', 'wplab-albedo-core-plugin' ),
     'param_name' => 'margins',
     'group' => esc_html__('Margins', 'wplab-albedo-core-plugin'),
  ),
  array(
     'type' => 'albedo_sides_box',
     'heading' => esc_html__( 'Row Margins (for medium screens)', 'wplab-albedo-core-plugin' ),
     'description' => esc_html__( 'Example: 10px 20% 20px 20%. Follow clockwise: top, right, bottom, left', 'wplab-albedo-core-plugin' ),
     'param_name' => 'margins_medium',
     'group' => esc_html__('Margins', 'wplab-albedo-core-plugin'),
  ),
  array(
     'type' => 'albedo_sides_box',
     'heading' => esc_html__( 'Row Margins (for small screens)', 'wplab-albedo-core-plugin' ),
     'description' => esc_html__( 'Example: 10px 20% 20px 20%. Follow clockwise: top, right, bottom, left', 'wplab-albedo-core-plugin' ),
     'param_name' => 'margins_mobile',
     'group' => esc_html__('Margins', 'wplab-albedo-core-plugin'),
  ),

  /*
    Paddings tab
  */
  array(
     'type' => 'albedo_sides_box',
     'heading' => esc_html__( 'Row Paddings', 'wplab-albedo-core-plugin' ),
     'description' => esc_html__( 'Example: 10px 20% 20px 20%. Follow clockwise: top, right, bottom, left', 'wplab-albedo-core-plugin' ),
     'param_name' => 'paddings',
     'group' => esc_html__('Paddings', 'wplab-albedo-core-plugin'),
  ),
  array(
     'type' => 'albedo_sides_box',
     'heading' => esc_html__( 'Row Paddings (for medium screens)', 'wplab-albedo-core-plugin' ),
     'description' => esc_html__( 'Example: 10px 20% 20px 20%. Follow clockwise: top, right, bottom, left', 'wplab-albedo-core-plugin' ),
     'param_name' => 'paddings_medium',
     'group' => esc_html__('Paddings', 'wplab-albedo-core-plugin'),
  ),
  array(
     'type' => 'albedo_sides_box',
     'heading' => esc_html__( 'Row Paddings (for small screens)', 'wplab-albedo-core-plugin' ),
     'description' => esc_html__( 'Example: 10px 20% 20px 20%. Follow clockwise: top, right, bottom, left', 'wplab-albedo-core-plugin' ),
     'param_name' => 'paddings_mobile',
     'group' => esc_html__('Paddings', 'wplab-albedo-core-plugin'),
  ),

  /*
    Responsiveness tab
  */
  array(
    'type' => 'checkbox',
    'heading' => esc_html__( 'Hide background image at large screens', 'wplab-albedo-core-plugin' ),
    'param_name' => 'hide_bg_large_screens',
    'description' => esc_html__( 'Background-color will be still visible', 'wplab-albedo-core-plugin' ),
    'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
    'group' => esc_html__('Responsiveness', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'checkbox',
    'heading' => esc_html__( 'Hide background image at medium screens', 'wplab-albedo-core-plugin' ),
    'param_name' => 'hide_bg_medium_screens',
    'description' => esc_html__( 'Background-color will be still visible', 'wplab-albedo-core-plugin' ),
    'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
    'group' => esc_html__('Responsiveness', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'checkbox',
    'heading' => esc_html__( 'Hide background image at small screens', 'wplab-albedo-core-plugin' ),
    'param_name' => 'hide_bg_small_screens',
    'description' => esc_html__( 'Background-color will be still visible', 'wplab-albedo-core-plugin' ),
    'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
    'group' => esc_html__('Responsiveness', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'checkbox',
    'heading' => esc_html__( 'Hide background image at extra small screens', 'wplab-albedo-core-plugin' ),
    'param_name' => 'hide_bg_estra_small_screens',
    'description' => esc_html__( 'Background-color will be still visible', 'wplab-albedo-core-plugin' ),
    'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
    'group' => esc_html__('Responsiveness', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'checkbox',
    'heading' => esc_html__( 'Hide row at Large screens', 'wplab-albedo-core-plugin' ),
    'param_name' => 'hide_lg',
    'description' => esc_html__( 'Switch to Yes if you need to hide this row at large desktops (1200px and up)', 'wplab-albedo-core-plugin' ),
    'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
    'group' => esc_html__('Responsiveness', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'checkbox',
    'heading' => esc_html__( 'Hide row at Medium Screens', 'wplab-albedo-core-plugin' ),
    'param_name' => 'hide_md',
    'description' => esc_html__( 'Switch to Yes if you need to hide this row at Medium screens (e.g. tablets in landscape mode)', 'wplab-albedo-core-plugin' ),
    'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
    'group' => esc_html__('Responsiveness', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'checkbox',
    'heading' => esc_html__( 'Hide row at Small screens', 'wplab-albedo-core-plugin' ),
    'param_name' => 'hide_sm',
    'description' => esc_html__( 'Switch to Yes if you need to hide this row at Tablets (small screen size)', 'wplab-albedo-core-plugin' ),
    'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
    'group' => esc_html__('Responsiveness', 'wplab-albedo-core-plugin'),
  ),
  array(
    'type' => 'checkbox',
    'heading' => esc_html__( 'Hide row at Extra Small screens', 'wplab-albedo-core-plugin' ),
    'param_name' => 'hide_xs',
    'description' => esc_html__( 'Switch to Yes if you need to hide this row at Phones (extra small screen size)', 'wplab-albedo-core-plugin' ),
    'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
    'group' => esc_html__('Responsiveness', 'wplab-albedo-core-plugin'),
  ),
));
