<?php

  /**
    * Quote Shortcode
  **/

  // Map VC shortcode
  require_once 'config.php';

  if ( class_exists( 'WPBakeryShortCode' ) ) {
    class WPBakeryShortCode_Albedo_Quote extends WPBakeryShortCode {

      protected function content( $atts, $content = null ) {
        global $wplab_albedo_core_plugin;
        $atts = vc_map_get_attributes( $this->getShortcode(), $atts );
        $attributes = $classes = array();

        /** load static stylesheet **/
    		wp_enqueue_style( 'wplab-albedo-quote', wplab_albedo_utils::locate_uri( '/css/front/css/shortcodes/quote.css'), false, _WPLAB_ALBEDO_CACHE_TIME_ );
        $variable_style = $wplab_albedo_core_plugin->lessify( wplab_albedo_utils::locate_uri( '/css/front/less/shortcodes/quote_variable.less') );
        wp_enqueue_style( 'wplab-albedo-quote-variable', $variable_style, false, _WPLAB_ALBEDO_CORE_CACHE_TIME_ );

        $shortcode_id = 'shortcode-' . esc_attr( $atts['el_id'] );
        $custom_css = '';

        if( ! filter_var( $atts['background_lazy'], FILTER_VALIDATE_BOOLEAN ) && $atts['bg_image'] <> '' ) {
    			$custom_css .= ' #' . $shortcode_id . ' { background-image: url(' . wp_get_attachment_url( $atts['bg_image'] ) . '); } ';
    		}

    		if( $atts['background_repeat'] <> '' ) {
    			$custom_css .= ' #' . $shortcode_id . ' { background-repeat: ' . $atts['background_repeat'] . '; } ';
    		}

    		if( $atts['background_position'] <> '' ) {
    			$custom_css .= ' #' . $shortcode_id . ' { background-position: ' . $atts['background_position'] . '; } ';
    		}

    		if( filter_var( $atts['background_cover'], FILTER_VALIDATE_BOOLEAN ) ) {
    			$custom_css .= ' #' . $shortcode_id . ' { background-size: cover; } ';
    		}


    		/**
    		 * Custom paddings
    		 **/
    		$inline_css = '';
    		if( $atts['paddings'] <> '' ) {
          $sides_data = explode( '|', $atts['paddings'] );
    			$inline_css = wplab_albedo_utils::get_styles( array(
    				'top_padding' 		=> $sides_data[0],
    				'right_padding' 	=> $sides_data[1],
    				'bottom_padding' 	=> $sides_data[2],
    				'left_padding' 		=> $sides_data[3],
    			), '' );
    		}

    		if( $inline_css <> '' ) {
    			$custom_css .= ' #' . $shortcode_id . ' {' . $inline_css . '}';
    		}

    		/**
    		 * Responsiveness, medium screen
    		 **/
    		$inline_css = '';

    			if( $atts['paddings_medium'] <> '' ) {
            $sides_data = explode( '|', $atts['paddings_medium'] );
    				$inline_css = wplab_albedo_utils::get_styles( array(
    					'top_padding' 		=> $sides_data[0],
    					'right_padding' 	=> $sides_data[1],
    					'bottom_padding' 	=> $sides_data[2],
    					'left_padding' 		=> $sides_data[3],
    				), '' );
    			}

    		if( $inline_css <> '' ) {
    			$custom_css .= '@media screen and (max-width: 992px) and (min-width: 767px) { #' . $shortcode_id . ' { ' . $inline_css . '} }';
    		}

    		/**
    		 * Responsiveness, small screen
    		 **/
    		$inline_css = '';

    			if( $atts['paddings_mobile'] <> '' ) {
            $sides_data = explode( '|', $atts['paddings_mobile'] );
    				$inline_css = wplab_albedo_utils::get_styles( array(
    					'top_padding' 		=> $sides_data[0],
    					'right_padding' 	=> $sides_data[1],
    					'bottom_padding' 	=> $sides_data[2],
    					'left_padding' 		=> $sides_data[3],
    				), '' );
    			}

    		if( $inline_css <> '' ) {
    			$custom_css .= '@media screen and (max-width: 767px) { #' . $shortcode_id . ' { ' . $inline_css . '} }';
    		}

        if( filter_var( $atts['custom_font_family'], FILTER_VALIDATE_BOOLEAN ) ) {

          $fontsData = $this->getFontsData( $atts, 'google_fonts' );

        	$googleFontsStyles = $this->googleFontsStyles( $fontsData );
        	$this->enqueueGoogleFonts( $fontsData );

          $custom_css .= '#' . $shortcode_id . ' p, #' . $shortcode_id . ' .text { ' . implode( ';', $googleFontsStyles ) . '; }';
        }

        $attributes[] = 'id="' . $shortcode_id . '"';
        if( $custom_css <> '' ) {
          $attributes[] = 'data-custom-css=\'' . $custom_css . '\'';
        }

        /**
      	 * Lazy load bg image
      	 **/
      	if( filter_var( $atts['background_lazy'], FILTER_VALIDATE_BOOLEAN ) && $atts['bg_image'] <> '' ) {
      		$classes[] = 'b-lazy';
      		$attributes[] = 'data-lazy-src="' . wp_get_attachment_url( $atts['bg_image'] ) . '"';
      	}

        ob_start();
        require plugin_dir_path( __FILE__ ) . '/../../vc_templates/albedo_quote.php';
        return ob_get_clean();
    	}

      protected function getFontsData( $atts, $paramName ) {
    		$googleFontsParam = new Vc_Google_Fonts();
    		$field = WPBMap::getParam( $this->shortcode, $paramName );
    		$fieldSettings = isset( $field['settings'], $field['settings']['fields'] ) ? $field['settings']['fields'] : array();
    		$fontsData = strlen( $atts[ $paramName ] ) > 0 ? $googleFontsParam->_vc_google_fonts_parse_attributes( $fieldSettings, $atts[ $paramName ] ) : '';

    		return $fontsData;
    	}

    	protected function googleFontsStyles( $fontsData ) {
    		// Inline styles
    		$fontFamily = explode( ':', $fontsData['values']['font_family'] );
    		$styles[] = 'font-family:' . $fontFamily[0];
    		$fontStyles = explode( ':', $fontsData['values']['font_style'] );
    		$styles[] = 'font-weight:' . $fontStyles[1];
    		$styles[] = 'font-style:' . $fontStyles[2];

    		return $styles;
    	}

    	protected function enqueueGoogleFonts( $fontsData ) {
    		// Get extra subsets for settings (latin/cyrillic/etc)
    		$settings = get_option( 'wpb_js_google_fonts_subsets' );
    		if ( is_array( $settings ) && ! empty( $settings ) ) {
    			$subsets = '&subset=' . implode( ',', $settings );
    		} else {
    			$subsets = '';
    		}

    		// We also need to enqueue font from googleapis
    		if ( isset( $fontsData['values']['font_family'] ) ) {
    			wp_enqueue_style( 'vc_google_fonts_' . vc_build_safe_css_class( $fontsData['values']['font_family'] ), '//fonts.googleapis.com/css?family=' . $fontsData['values']['font_family'] . $subsets );
    		}
    	}

    }
  }
