<?php

  /**
    * Progress Bar Shortcode
  **/

  // Map VC shortcode
  require_once 'config.php';

  if ( class_exists( 'WPBakeryShortCode' ) ) {
    class WPBakeryShortCode_Albedo_Progress_Bar extends WPBakeryShortCode {

      protected function content( $atts, $content = null ) {

        $atts = vc_map_get_attributes( $this->getShortcode(), $atts );
        $attributes = $classes = array();
        $custom_css = '';
        $shortcode_id = 'shortcode-' . esc_attr( $atts['el_id'] );

        /** load static stylesheet **/
    		wp_enqueue_style( 'wplab-albedo-progress', wplab_albedo_utils::locate_uri( '/css/front/css/shortcodes/progress.css'), false, _WPLAB_ALBEDO_CORE_CACHE_TIME_ );

        global $wplab_albedo_core_plugin;
        $variable_style = $wplab_albedo_core_plugin->lessify( wplab_albedo_utils::locate_uri( '/css/front/less/shortcodes/progress_variable.less') );
        wp_enqueue_style( 'wplab-albedo-progress-variable', $variable_style, false, _WPLAB_ALBEDO_CORE_CACHE_TIME_ );

        /**
    		 * Custom colors
    		 **/
    		if( $atts['bar_bg_color'] <> '' ) {
    			$custom_css .= ' #' . $shortcode_id . ' .progress-bar-value-inner { background-color: ' . $atts['bar_bg_color'] . '; }';
    		}

    		if( $atts['bar_accent_color'] <> '' ) {
    			$custom_css .= ' #' . $shortcode_id . ' .value { background-color: ' . $atts['bar_accent_color'] . ' !important; }';
    		}

    		if( $atts['text_color'] <> '' ) {
    			$custom_css .= ' #' . $shortcode_id . ' .progress-bar-title { color: ' . $atts['text_color'] . '; }';
    		}

    		if( $atts['value_color'] <> '' ) {
    			$custom_css .= ' #' . $shortcode_id . ' .num { color: ' . $atts['value_color'] . '; }';
    		}

        $attributes[] = 'id="' . $shortcode_id . '"';
        if( $custom_css <> '' ) {
          $attributes[] = 'data-custom-css=\'' . $custom_css . '\'';
        }

        ob_start();
        require plugin_dir_path( __FILE__ ) . '/../../vc_templates/albedo_progress_bar.php';
        return ob_get_clean();

      }
    }
  }
