<?php

vc_map( array(
  'name' => esc_html__( 'Portfolio Wall', 'wplab-albedo-core-plugin' ),
	'base' => 'albedo_portfolio_wall',
  'icon' => $this->plugin_uri . '/assets/shortcode_icons/portfolio-wall.png',
  'front_enqueue_js' => $this->plugin_uri . '/shortcodes/portfolio-wall/js/vc.js',
	'category' => esc_html__( 'Portfolio', 'wplab-albedo-core-plugin' ),
	'description' => esc_html__( 'Add portfolio wall grid', 'wplab-albedo-core-plugin' ),
	'params' => array(

    /**
     *  Query tab
    **/

    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Posts per page', 'wplab-albedo-core-plugin' ),
      'param_name' => 'posts_per_page',
      'admin_label' => true,
      'value' => '9',
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Posts ordering method', 'wplab-albedo-core-plugin'),
      'param_name' => 'order_by',
      'value' => array(
        esc_html__('Date', 'wplab-albedo-core-plugin') => 'date',
        esc_html__('ID', 'wplab-albedo-core-plugin') => 'ID',
        esc_html__('Modified date', 'wplab-albedo-core-plugin') => 'modified',
        esc_html__('Title', 'wplab-albedo-core-plugin') => 'title',
        esc_html__('Random', 'wplab-albedo-core-plugin') => 'rand',
        esc_html__('Menu', 'wplab-albedo-core-plugin') => 'menu',
      ),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Posts sorting method', 'wplab-albedo-core-plugin'),
      'param_name' => 'sort_by',
      'value' => array(
        esc_html__('Descending', 'wplab-albedo-core-plugin') => 'DESC',
        esc_html__('Ascending', 'wplab-albedo-core-plugin') => 'ASC',
      ),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Query from category', 'wplab-albedo-core-plugin'),
      'param_name' => 'tax_query_type',
      'admin_label' => true,
      'value' => array(
        esc_html__('All', 'wplab-albedo-core-plugin') => '',
        esc_html__('Only', 'wplab-albedo-core-plugin') => 'only',
        esc_html__('Except', 'wplab-albedo-core-plugin') => 'except',
      ),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textarea',
      'heading' => esc_html__( 'Categories', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'Type here category slugs to include or exclude, based on previous parameter. Explode multiple categories slugs by comma', 'wplab-albedo-core-plugin' ),
      'param_name' => 'tax_query_terms',
      'value' => '',
      'admin_label' => true,
      'dependency' => array(
  			'element' => 'tax_query_type',
  			'value' => array( 'only', 'except' ),
  		),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'el_id',
      'heading' => esc_html__( 'Element ID', 'wplab-albedo-core-plugin' ),
      'param_name' => 'el_id',
      'settings' => array(
        'auto_generate' => true,
      ),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
      'description' => esc_html__( 'Unique identifier of this element', 'wplab-albedo-core-plugin' ),
    ),


    /**
     *  Appearance tab
    **/
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Display post title', 'wplab-albedo-core-plugin' ),
      'param_name' => 'display_title',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('Appearance', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Display post categories', 'wplab-albedo-core-plugin' ),
      'param_name' => 'display_hover_cats',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('Appearance', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Display zoom icon', 'wplab-albedo-core-plugin' ),
      'param_name' => 'display_zoom_icon',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('Appearance', 'wplab-albedo-core-plugin'),
    ),

    /**
     *  Style tab
    **/
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Number of columns', 'wplab-albedo-core-plugin'),
      'param_name' => 'columns',
      'value' => array(
        esc_html__('2 columns', 'wplab-albedo-core-plugin') => 'col-md-6',
        esc_html__('4 columns', 'wplab-albedo-core-plugin') => 'col-md-3',
      ),
      'group' => esc_html__('Style', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Overlay color', 'wplab-albedo-core-plugin'),
      'param_name' => 'overlay_color',
      'value' => $this->cfg['base_colors'],
      'group' => esc_html__('Style', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Row height', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'value in pixels, e.g.: 460', 'wplab-albedo-core-plugin' ),
      'param_name' => 'grid_row_height',
      'value' => '460',
      'group' => esc_html__('Style', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Row height on mobiles', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'value in pixels, e.g.: 300', 'wplab-albedo-core-plugin' ),
      'param_name' => 'grid_row_height_mobile',
      'value' => '300',
      'group' => esc_html__('Style', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Thumbnails dimensions', 'wplab-albedo-core-plugin'),
      'param_name' => 'thumbs_dimensions',
      'value' => array(
        esc_html__('Original size', 'wplab-albedo-core-plugin') => '',
        esc_html__('Crop thumbnails', 'wplab-albedo-core-plugin') => 'crop',
      ),
      'group' => esc_html__('Style', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Thumbnail width', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'value in pixels, e.g.: 320', 'wplab-albedo-core-plugin' ),
      'param_name' => 'thumb_width',
      'value' => '320',
      'dependency' => array(
  			'element' => 'thumbs_dimensions',
  			'value' => array( 'crop' ),
  		),
      'group' => esc_html__('Style', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Thumbnail height', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'value in pixels, e.g.: 320', 'wplab-albedo-core-plugin' ),
      'param_name' => 'thumb_height',
      'value' => '180',
      'dependency' => array(
  			'element' => 'thumbs_dimensions',
  			'value' => array( 'crop' ),
  		),
      'group' => esc_html__('Style', 'wplab-albedo-core-plugin'),
    ),
	),
));
