<?php

  /**
    * Portfolio Full Screen Photos Shortcode
  **/

  // Map VC shortcode
  require_once 'config.php';

  if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
    class WPBakeryShortCode_Albedo_Portfolio_Full_Screen_Photos extends WPBakeryShortCode {

      protected function content( $atts, $content = null ) {
        global $wplab_albedo_core_plugin;

        $atts = vc_map_get_attributes( $this->getShortcode(), $atts );

        $attributes = $classes = array();

        $shortcode_id = 'shortcode-' . $atts['el_id'];

    		$postfix = defined('SCRIPT_DEBUG') && SCRIPT_DEBUG ? '' : '.min';

        /** shortcode styles **/
    		wp_enqueue_style( 'wplab-albedo-photo-fullscreen', wplab_albedo_utils::locate_uri( '/css/front/css/shortcodes/photo_fullscreen.css'), false, _WPLAB_ALBEDO_CACHE_TIME_ );
        $variable_style = $wplab_albedo_core_plugin->lessify( wplab_albedo_utils::locate_uri( '/css/front/less/shortcodes/photo_fullscreen_variable.less') );
    		wp_enqueue_style( 'wplab-albedo-photo-fullscreen-variable', $variable_style, false, _WPLAB_ALBEDO_CACHE_TIME_ );

    		wp_enqueue_script( 'wplab-albedo-modernizr-cssmask', wplab_albedo_utils::locate_uri('/js/libs/checkCSSMask.min.js'), array('jquery'), _WPLAB_ALBEDO_CACHE_TIME_, true );
    		wp_enqueue_script( 'wplab-albedo-photo-fullscreen', wplab_albedo_utils::locate_uri('/framework-customizations/extensions/shortcodes/shortcodes/photo-fullscreen/static/js/scripts' . $postfix . '.js'), array('jquery'), _WPLAB_ALBEDO_CACHE_TIME_, true );

    		if( $atts['overlay_color'] <> '' ) {
    			$inline_css = ' #' . $shortcode_id . ' .overlay { background-color: ' . $atts['overlay_color'] . '; }';
    			$attributes[] = "data-custom-css='" . $inline_css . "'";
    		}

        ob_start();
        require plugin_dir_path( __FILE__ ) . '/../../vc_templates/albedo_portfolio_full_screen_photos.php';
        return ob_get_clean();

      }

    }
  }
