<?php

vc_map( array(
  'name' => esc_html__( 'Video Lightbox', 'wplab-albedo-core-plugin' ),
	'base' => 'albedo_video_lightbox',
  'icon' => $this->plugin_uri . '/assets/shortcode_icons/video-lightbox.png',
  'front_enqueue_js' => $this->plugin_uri . '/shortcodes/media-video-lightbox/js/vc.js',
	'category' => esc_html__( 'Media', 'wplab-albedo-core-plugin' ),
	'description' => esc_html__( 'Add lightbox video', 'wplab-albedo-core-plugin' ),
	'params' => array(

    /**
     *  General tab
    **/

    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Video URL', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'This shortcode supports YouTube or Vimeo videos only', 'wplab-albedo-core-plugin' ),
      'param_name' => 'video',
      'value' => '',
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'attach_image',
      'heading' => esc_html__('Video poster image', 'wplab-albedo-core-plugin'),
      'description' => esc_html__('Either upload a new, or choose an existing image from your media library.', 'wplab-albedo-core-plugin'),
      'param_name' => 'poster_image',
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Alternate Text / Description', 'wplab-albedo-core-plugin' ),
      'param_name' => 'alt',
      'value' => '',
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Poster Width', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'Set image width (optional)', 'wplab-albedo-core-plugin' ),
      'param_name' => 'width',
      'value' => '',
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Poster Height', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'Set image height (optional)', 'wplab-albedo-core-plugin' ),
      'param_name' => 'height',
      'value' => '',
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Video Style', 'wplab-albedo-core-plugin'),
      'param_name' => 'style',
      'save_always' => true,
      'value' => array(
        esc_html__('Default / custom effects', 'wplab-albedo-core-plugin') => '',
        esc_html__('Boxed style', 'wplab-albedo-core-plugin') => 'boxed',
        esc_html__('Boxed, rounded corners', 'wplab-albedo-core-plugin') => 'boxed_rounded',
        esc_html__('Polaroid', 'wplab-albedo-core-plugin') => 'polaroid',
      ),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Add hover effect?', 'wplab-albedo-core-plugin' ),
      'param_name' => 'hover_effect',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Hover Effect', 'wplab-albedo-core-plugin'),
      'param_name' => 'hover_style',
      'save_always' => true,
      'value' => array(
        esc_html__('Default', 'wplab-albedo-core-plugin') => 'default',
        esc_html__('Slide (from right to left)', 'wplab-albedo-core-plugin') => 'slide-right-left',
        esc_html__('Zoom Out', 'wplab-albedo-core-plugin') => 'zoom-out',
        esc_html__('Zoom In', 'wplab-albedo-core-plugin') => 'zoom-in',
        esc_html__('Big Zoom', 'wplab-albedo-core-plugin') => 'big-zoom',
        esc_html__('Zoom 3D', 'wplab-albedo-core-plugin') => 'zoom-3d',
        esc_html__('Zoom and Slide', 'wplab-albedo-core-plugin') => 'zoom-slide',
        esc_html__('Shine', 'wplab-albedo-core-plugin') => 'shine',
      ),
      'dependency' => array(
  			'element' => 'hover_effect',
  			'not_empty' => true,
  		),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Lazy load', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'If enabled, poster image will be loaded via JavaScript to increase page loading speed', 'wplab-albedo-core-plugin' ),
      'param_name' => 'lazy_load',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'el_id',
      'heading' => esc_html__( 'Element ID', 'wplab-albedo-core-plugin' ),
      'param_name' => 'el_id',
      'settings' => array(
        'auto_generate' => true,
      ),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
      'description' => esc_html__( 'Unique identifier of this element', 'wplab-albedo-core-plugin' ),
    ),

    /**
     *  Styling tab
    **/
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Video align', 'wplab-albedo-core-plugin'),
      'param_name' => 'video_align',
      'value' => array(
        esc_html__('Default', 'wplab-albedo-core-plugin') => '',
        esc_html__('Left', 'wplab-albedo-core-plugin') => 'alignleft',
        esc_html__('Center', 'wplab-albedo-core-plugin') => 'aligncenter',
        esc_html__('Right', 'wplab-albedo-core-plugin') => 'alignright',
      ),
      'group' => esc_html__('Styling', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Animate video container', 'wplab-albedo-core-plugin' ),
      'param_name' => 'animation',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('Styling', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Animation Effect', 'wplab-albedo-core-plugin'),
      'param_name' => 'animation_effect',
      'value' => $this->cfg['animations'],
      'save_always' => true,
      'dependency' => array(
  			'element' => 'animation',
  			'not_empty' => true,
  		),
      'group' => esc_html__('Styling', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Animation delay', 'wplab-albedo-core-plugin' ),
      'param_name' => 'animation_delay',
      'save_always' => true,
      'value' => '0.3s',
      'dependency' => array(
  			'element' => 'animation',
  			'not_empty' => true,
  		),
      'group' => esc_html__('Styling', 'wplab-albedo-core-plugin'),
    ),
    array(
       'type' => 'albedo_sides_box',
       'heading' => esc_html__( 'Video Margins', 'wplab-albedo-core-plugin' ),
       'description' => esc_html__( 'Example: 10px 20% 20px 20%. Follow clockwise: top, right, bottom, left', 'wplab-albedo-core-plugin' ),
       'param_name' => 'margins',
       'group' => esc_html__('Styling', 'wplab-albedo-core-plugin'),
    ),
    array(
       'type' => 'albedo_sides_box',
       'heading' => esc_html__( 'Video Paddings', 'wplab-albedo-core-plugin' ),
       'description' => esc_html__( 'Example: 10px 20% 20px 20%. Follow clockwise: top, right, bottom, left', 'wplab-albedo-core-plugin' ),
       'param_name' => 'paddings',
       'group' => esc_html__('Styling', 'wplab-albedo-core-plugin'),
    ),
    array(
  		'type' => 'colorpicker',
  		'heading' => esc_html__( 'Border color', 'wplab-albedo-core-plugin' ),
  		'param_name' => 'border_color',
  		'value' => '',
  		'group' => esc_html__('Styling', 'wplab-albedo-core-plugin'),
  	),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Border style', 'wplab-albedo-core-plugin'),
      'param_name' => 'border_style',
      'save_always' => true,
      'value' => array(
        esc_html__('None', 'wplab-albedo-core-plugin') => 'none',
        esc_html__('Hidden', 'wplab-albedo-core-plugin') => 'hidden',
        esc_html__('Dotted', 'wplab-albedo-core-plugin') => 'dotted',
        esc_html__('Dashed', 'wplab-albedo-core-plugin') => 'dashed',
        esc_html__('Solid', 'wplab-albedo-core-plugin') => 'solid',
        esc_html__('Double', 'wplab-albedo-core-plugin') => 'double',
        esc_html__('Groove', 'wplab-albedo-core-plugin') => 'groove',
        esc_html__('Ridge', 'wplab-albedo-core-plugin') => 'ridge',
      ),
      'group' => esc_html__('Styling', 'wplab-albedo-core-plugin'),
    ),
    array(
       'type' => 'albedo_sides_box',
       'heading' => esc_html__( 'Border width', 'wplab-albedo-core-plugin' ),
       'description' => esc_html__( 'Example: 10px 20% 20px 20%. Follow clockwise: top, right, bottom, left', 'wplab-albedo-core-plugin' ),
       'param_name' => 'border_width',
       'group' => esc_html__('Styling', 'wplab-albedo-core-plugin'),
    ),
    array(
       'type' => 'albedo_sides_box',
       'heading' => esc_html__( 'Border radius', 'wplab-albedo-core-plugin' ),
       'description' => esc_html__( 'Example: 10px 20% 20px 20%. Follow clockwise: top, right, bottom, left', 'wplab-albedo-core-plugin' ),
       'param_name' => 'border_radius',
       'group' => esc_html__('Styling', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Add CSS shadow', 'wplab-albedo-core-plugin' ),
      'param_name' => 'css_shadow',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('Styling', 'wplab-albedo-core-plugin'),
    ),
    array(
  		'type' => 'colorpicker',
  		'heading' => esc_html__( 'Shadow color', 'wplab-albedo-core-plugin' ),
  		'param_name' => 'shadow_color',
  		'value' => '',
      'dependency' => array(
  			'element' => 'css_shadow',
  			'not_empty' => true,
  		),
  		'group' => esc_html__('Styling', 'wplab-albedo-core-plugin'),
  	),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Position', 'wplab-albedo-core-plugin'),
      'param_name' => 'shadow_type',
      'save_always' => true,
      'value' => array(
        esc_html__('Outside', 'wplab-albedo-core-plugin') => 'outside',
        esc_html__('Inside', 'wplab-albedo-core-plugin') => 'inside',
      ),
      'dependency' => array(
  			'element' => 'css_shadow',
  			'not_empty' => true,
  		),
      'group' => esc_html__('Styling', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Blur Radius', 'wplab-albedo-core-plugin' ),
      'param_name' => 'shadow_blur_radius',
      'save_always' => true,
      'value' => '0',
      'dependency' => array(
  			'element' => 'css_shadow',
  			'not_empty' => true,
  		),
      'group' => esc_html__('Styling', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Spread Radius', 'wplab-albedo-core-plugin' ),
      'param_name' => 'shadow_spread_radius',
      'save_always' => true,
      'value' => '0',
      'dependency' => array(
  			'element' => 'css_shadow',
  			'not_empty' => true,
  		),
      'group' => esc_html__('Styling', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Horizontal Length', 'wplab-albedo-core-plugin' ),
      'param_name' => 'shadow_h_length',
      'save_always' => true,
      'value' => '0',
      'dependency' => array(
  			'element' => 'css_shadow',
  			'not_empty' => true,
  		),
      'group' => esc_html__('Styling', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Vertical Length', 'wplab-albedo-core-plugin' ),
      'param_name' => 'shadow_v_length',
      'save_always' => true,
      'value' => '0',
      'dependency' => array(
  			'element' => 'css_shadow',
  			'not_empty' => true,
  		),
      'group' => esc_html__('Styling', 'wplab-albedo-core-plugin'),
    ),

  )
));
