<?php

  /**
    * Masonry Image Gallery Shortcode
  **/

  // Map VC shortcode
  require_once 'config.php';

  if ( class_exists( 'WPBakeryShortCode' ) ) {
    class WPBakeryShortCode_Albedo_Masonry_Images_Gallery extends WPBakeryShortCode {

      protected function content( $atts, $content = null ) {

        $atts = vc_map_get_attributes( $this->getShortcode(), $atts );

        $attributes = $classes = array();

        $id = $atts['el_id'];
        $shortcode_id = 'shortcode-' . esc_attr( $id );
        $attributes[] = 'id="' . $shortcode_id . '"';

        $postfix = defined('SCRIPT_DEBUG') && SCRIPT_DEBUG ? '' : '.min';

        /** include LightGallery library styles **/
    		wp_enqueue_style( 'lightgallery', get_template_directory_uri() . '/css/libs/lightgallery.min.css', false, _WPLAB_ALBEDO_CORE_CACHE_TIME_ );
    		wp_enqueue_style( 'lightgallery-transitions', get_template_directory_uri() . '/css/libs/lg-transitions.min.css', false, _WPLAB_ALBEDO_CORE_CACHE_TIME_ );
    		wp_enqueue_script( 'lightgallery');

    		/** include Masonry Grid **/
    		wp_enqueue_style( 'masonry', get_template_directory_uri() . '/css/libs/masonry.min.css', false, _WPLAB_ALBEDO_CORE_CACHE_TIME_ );
    		wp_enqueue_style( 'masonry-effects', get_template_directory_uri() . '/css/libs/masonry_effects.min.css', false, _WPLAB_ALBEDO_CORE_CACHE_TIME_ );

        wp_dequeue_script( 'isotope');
        wp_register_script( 'albedo-isotope', wplab_albedo_utils::locate_uri( '/js/libs/isotope.pkgd.min.js'), array( 'jquery' ), _WPLAB_ALBEDO_CACHE_TIME_, true );
    		wp_enqueue_script( 'albedo-isotope' );

    		wp_enqueue_script( 'anim-on-scroll' );

    		/** include lightbox **/
    		/** shortcode script **/
    		$js_vars = array(
    			'lightboxEffect' => fw_get_db_customizer_option( 'lightbox_effect' ),
    			'lightboxEasing' => fw_get_db_customizer_option( 'lightbox_easing' ),
    			'lightboxThumbs' => filter_var( fw_get_db_customizer_option( 'lightbox_thumbnails' ), FILTER_VALIDATE_BOOLEAN ),
    			'lightboxCaptions' => filter_var( fw_get_db_customizer_option( 'lightbox_captions' ), FILTER_VALIDATE_BOOLEAN ),
    			'lightboxFullscreen' => filter_var( fw_get_db_customizer_option( 'lightbox_fullscreen' ), FILTER_VALIDATE_BOOLEAN ),
    			'lightboxZoom' => filter_var( fw_get_db_customizer_option( 'lightbox_zoom' ), FILTER_VALIDATE_BOOLEAN ),
    			'lightboxDownload' => filter_var( fw_get_db_customizer_option( 'lightbox_download' ), FILTER_VALIDATE_BOOLEAN ),
    			'lightboxAutoplay' => filter_var( fw_get_db_customizer_option( 'lightbox_autoplay/enabled' ), FILTER_VALIDATE_BOOLEAN ),
    			'lightboxAutoplaySpeed' => absint( fw_get_db_customizer_option( 'lightbox_autoplay/yes/speed' ) ),
    		);

    		if( $js_vars['lightboxThumbs'] == true ) {
    			wp_enqueue_script( 'lightgallery-thumb');
    		}
    		if( $js_vars['lightboxFullscreen'] == true ) {
    			wp_enqueue_script( 'lightgallery-fullscreen');
    		}
    		if( $js_vars['lightboxAutoplay'] == true ) {
    			wp_enqueue_script( 'lightgallery-autoplay');
    		}
    		if( $js_vars['lightboxZoom'] == true ) {
    			wp_enqueue_script( 'lightgallery-zoom');
    		}

    		wp_enqueue_script( 'wplab-albedo-masonry-image-grid', wplab_albedo_utils::locate_uri('/framework-customizations/extensions/shortcodes/shortcodes/media-masonry-images/static/js/scripts' . $postfix . '.js'), array('jquery', 'masonry'), _WPLAB_ALBEDO_CORE_CACHE_TIME_, true );
    		wp_localize_script( 'wplab-albedo-masonry-image-grid', 'wplabAlbedoMediaMasonryImages', $js_vars );

    		if( is_numeric( $atts['border_radius'] ) ) {
          $custom_css = ' #' . $shortcode_id . ' figure img, #' . $shortcode_id . ' .caption, #' . $shortcode_id . ' figure:before { border-radius: ' . absint( $atts['border_radius'] ) . 'px; }';
          $attributes[] = 'data-custom-css="' . $custom_css . '"';
    		}

        ob_start();
        require plugin_dir_path( __FILE__ ) . '/../../vc_templates/albedo_masonry_images_gallery.php';
        return ob_get_clean();

      }

    }
  }
