(function ( $ ) {

	function wplab_albedo_masonry_images_gallery_refresh( element ) {

		var $iframe = $("#vc_inline-frame"),
		contentWindow = $iframe[0].contentWindow,
		iframeContents = $iframe.contents(),
		$element = element.$el.find('.images-masonry-gallery'),
		elementId = $element.attr('id'),
		cssId = 'albedo-custom-css-id-' + elementId;

		iframeContents.find('#' + cssId).remove();
		iframeContents.find("head").append('<!-- auto generated custom css by element / shortcode --><style type="text/css" id="' + cssId + '">' + $element.data('custom-css') + '</style>');

		if( 'albedo_masonry_images_init' in contentWindow ) {
			contentWindow.albedo_masonry_images_init();
		} else {
			setTimeout( function() {
				contentWindow.albedo_masonry_images_init();
			}, 500 );
		}

	}

	window.InlineShortcodeView_albedo_masonry_images_gallery = window.InlineShortcodeView.extend({
		render: function () {

			window.InlineShortcodeView_albedo_masonry_images_gallery.__super__.render.call( this );
			wplab_albedo_masonry_images_gallery_refresh( this );

		  return this;
		},
		updated: function() {
			_.each(vc.shortcodes.where({
					parent_id: this.model.get("id")
			}), function(model) {
					model.view.parent_view = this, model.view.parentChanged()
			}, this), _.defer(_.bind(function() {
					vc.events.trigger("shortcodeView:updated", this.model), vc.events.trigger("shortcodeView:updated:" + this.model.get("shortcode"), this.model), vc.events.trigger("shortcodeView:updated:" + this.model.get("id"), this.model)
			}, this))

			// wait until element will be fully loaded
			var instance = this;
	    $(document).ajaxStop(function () {
				wplab_albedo_masonry_images_gallery_refresh( instance );
			});
		},
		clone: function(e) {
			var new_model, builder = new vc.ShortcodesBuilder;
			if (_.isObject(e) && e.preventDefault() && e.stopPropagation(), this.builder && !this.builder.is_build_complete) return !1;
			this.builder = builder, new_model = vc.CloneModel(builder, this.model, this.model.get("parent_id")), builder.setResultMessage(window.sprintf(window.i18nLocale.inline_element_cloned, new_model.setting("name"), new_model.get("id"))), builder.render()

			wplab_albedo_masonry_images_gallery_refresh( this );
		}
	});

})( window.jQuery );
