<?php

vc_map( array(
  'name' => esc_html__( 'Justified image gallery', 'wplab-albedo-core-plugin' ),
	'base' => 'albedo_images_gallery',
  'icon' => $this->plugin_uri . '/assets/shortcode_icons/justified-image-gallery.png',
  'front_enqueue_js' => $this->plugin_uri . '/shortcodes/media-image-gallery/js/vc.js',
	'category' => esc_html__( 'Media', 'wplab-albedo-core-plugin' ),
	'description' => esc_html__( 'Add images grid', 'wplab-albedo-core-plugin' ),
	'params' => array(

    /**
     *  General tab
    **/
    array(
      'type' => 'attach_images',
      'heading' => esc_html__('Choose images', 'wplab-albedo-core-plugin'),
      'param_name' => 'images',
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'el_id',
      'heading' => esc_html__( 'Element ID', 'wplab-albedo-core-plugin' ),
      'param_name' => 'el_id',
      'settings' => array(
        'auto_generate' => true,
      ),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
      'description' => esc_html__( 'Unique identifier of this element', 'wplab-albedo-core-plugin' ),
    ),

    /**
     *  Grid tab
    **/
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Row height', 'wplab-albedo-core-plugin' ),
      'param_name' => 'row_height',
      'value' => '260',
      'save_always' => true,
      'group' => esc_html__('Grid', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Maximum row height', 'wplab-albedo-core-plugin' ),
      'param_name' => 'max_row_height',
      'value' => '300',
      'save_always' => true,
      'group' => esc_html__('Grid', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Margins between images', 'wplab-albedo-core-plugin' ),
      'param_name' => 'margins',
      'value' => '40',
      'save_always' => true,
      'group' => esc_html__('Grid', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Display image caption', 'wplab-albedo-core-plugin' ),
      'param_name' => 'display_caption',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('Grid', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Randomize photos on load', 'wplab-albedo-core-plugin' ),
      'param_name' => 'randomize',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('Grid', 'wplab-albedo-core-plugin'),
    ),



    /**
     *  Style tab
    **/
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Border radius for images', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'value in pixels, e.g.: 20. This option may not work if you are using hover effects', 'wplab-albedo-core-plugin' ),
      'param_name' => 'border_radius',
      'value' => '',
      'group' => esc_html__('Style', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Overlay color', 'wplab-albedo-core-plugin'),
      'param_name' => 'overlay_color',
      'save_always' => true,
      'value' => array(
        esc_html__('Dark', 'wplab-albedo-core-plugin') => 'dark',
        esc_html__('Theme Accent', 'wplab-albedo-core-plugin') => 'accent',
      ),
      'group' => esc_html__('Style', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Add shadows', 'wplab-albedo-core-plugin' ),
      'param_name' => 'shadows',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('Style', 'wplab-albedo-core-plugin'),
    ),

  )
));
