<?php

vc_map( array(
  'name' => esc_html__( 'Link', 'wplab-albedo-core-plugin' ),
	'base' => 'albedo_link',
  'icon' => $this->plugin_uri . '/assets/shortcode_icons/link.png',
	'category' => esc_html__( 'Content Elements', 'wplab-albedo-core-plugin' ),
	'description' => esc_html__( 'Add a link', 'wplab-albedo-core-plugin' ),
	'params' => array(

    /**
     *  General tab
    **/
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Link URL', 'wplab-albedo-core-plugin' ),
      'param_name' => 'url',
      'value' => '',
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Display domain only?', 'wplab-albedo-core-plugin' ),
      'param_name' => 'domain_only',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Link text', 'wplab-albedo-core-plugin' ),
      'param_name' => 'text',
      'admin_label' => true,
      'value' => '',
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Open link at new tab?', 'wplab-albedo-core-plugin' ),
      'param_name' => 'target',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => '_blank' ),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'el_id',
      'heading' => esc_html__( 'Element ID', 'wplab-albedo-core-plugin' ),
      'param_name' => 'el_id',
      'settings' => array(
        'auto_generate' => true,
      ),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
      'description' => esc_html__( 'Unique identifier of this element', 'wplab-albedo-core-plugin' ),
    ),

    /**
     *  Styling tab
    **/
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Box style', 'wplab-albedo-core-plugin'),
      'param_name' => 'style',
      'save_always' => true,
      'value' => $this->cfg['base_colors'],
      'group' => esc_html__('Styling', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Add shadow?', 'wplab-albedo-core-plugin' ),
      'param_name' => 'shadow',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('Styling', 'wplab-albedo-core-plugin'),
    ),

    /**
     *  Animation tab
    **/
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Enable typed animation', 'wplab-albedo-core-plugin' ),
      'param_name' => 'typed_animation',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('Animation', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Animation delay', 'wplab-albedo-core-plugin' ),
      'param_name' => 'typed_delay',
      'save_always' => true,
      'value' => '150',
      'dependency' => array(
  			'element' => 'typed_animation',
  			'not_empty' => true,
  		),
      'group' => esc_html__('Animation', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Animation speed', 'wplab-albedo-core-plugin' ),
      'param_name' => 'typed_speed',
      'save_always' => true,
      'value' => '100',
      'dependency' => array(
  			'element' => 'typed_animation',
  			'not_empty' => true,
  		),
      'group' => esc_html__('Animation', 'wplab-albedo-core-plugin'),
    ),


  )
));
