(function($){
	"use strict";

	window.albedo_contact_form_init = function() {

		$( '.albedo-vc-contact-form .form-builder-submit' ).off('click').on( 'click', function() {

			var $form = $(this).parents('form'),
			successMsg = $form.data('msg-success');

			// on form submit
		  $.validate({
				modules: 'html5',
		    borderColorOnError: '',
				form: $form,
				lang: $form.data('lang'),
				onSuccess: function( form ) {

					var $form = $(form),
					values = $form.serialize();

					$.ajax({
						url: wprotoEngineVars.ajaxurl,
						type: "POST",
						dataType: 'json',
						data: {
							'action' : 'albedo_contact_form',
							'form_data' : $form.data('form-data'),
							'security' : $form.data('nonce'),
							'form_values' : values
						},
						success: function( answer ) {

							if( $.trim( $form.data('redirect-url') ) != '' ) {
								window.location = $form.data('redirect-url');
								return false;
							}

							if( answer.result == 'ok' ) {
								$form.html( '<div>' + $form.data('msg-success') + '</div>');
							} else {
								$form.find('span.form-msg').remove();
								$form.append( '<span class="form-msg help-block form-error">' + answer.error + '</span>' );
							}


						}
					});

					return false;

				}
		  });

	    return false;
	  });

	}

	window.albedo_contact_form_init();

})( window.jQuery );
