<?php

vc_map( array(
  'name' => esc_html__( 'Recaptcha', 'wplab-albedo-core-plugin' ),
	'base' => 'albedo_contact_form_recaptcha',
  'content_element' => true,
  'category' => esc_html__( 'Form Fields', 'wplab-albedo-core-plugin' ),
  'icon' => $this->plugin_uri . '/assets/shortcode_icons/recaptcha.png',
  'as_child' => array( 'only' => 'albedo_contact_form,vc_column_inner' ),
	'params' => array(

    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Label', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'Enter field label (it will be displayed on the web site)', 'wplab-albedo-core-plugin' ),
      'param_name' => 'label',
      'admin_label' => true,
      'value' => '',
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Site key', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'Your website key. More on how to configure ReCaptcha: https://www.google.com/recaptcha', 'wplab-albedo-core-plugin' ),
      'param_name' => 'site_key',
      'value' => '',
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Secret key', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'Your secret key. More on how to configure ReCaptcha: https://www.google.com/recaptcha', 'wplab-albedo-core-plugin' ),
      'param_name' => 'secret_key',
      'value' => '',
    ),

  )
));

if ( class_exists( 'WPBakeryShortCode' ) ) {
  class WPBakeryShortCode_Albedo_Contact_Form_Recaptcha extends WPBakeryShortCode {
  }
}
