<?php

vc_map( array(
  'name' => esc_html__( 'Button', 'wplab-albedo-core-plugin' ),
	'base' => 'albedo_button',
  'icon' => $this->plugin_uri . '/assets/shortcode_icons/button.png',
	'category' => esc_html__( 'Content Elements', 'wplab-albedo-core-plugin' ),
	'description' => esc_html__( 'Add a button', 'wplab-albedo-core-plugin' ),
  'front_enqueue_js' => $this->plugin_uri . '/shortcodes/button/js/vc.js',
	'params' => array(

    /**
     *  Attributes tab
    **/
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Button Label', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'This is the text that appears on your button', 'wplab-albedo-core-plugin' ),
      'param_name' => 'label',
      'admin_label' => true,
      'value' => esc_html__( 'Submit', 'wplab-albedo-core-plugin' ),
      'save_always' => true,
      'group' => esc_html__('Attributes', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Button Link', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'Where should your button link to', 'wplab-albedo-core-plugin' ),
      'param_name' => 'link',
      'value' => '#',
      'save_always' => true,
      'group' => esc_html__('Attributes', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Open Link in New Window', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'Select here if you want to open the linked page in a new window', 'wplab-albedo-core-plugin' ),
      'param_name' => 'target',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => '_blank' ),
      'group' => esc_html__('Attributes', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'el_id',
      'heading' => esc_html__( 'Button ID', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'Here you can set unique identifier for this button', 'wplab-albedo-core-plugin' ),
      'param_name' => 'el_id',
      'settings' => array(
        'auto_generate' => true,
      ),
      'value' => '',
      'group' => esc_html__('Attributes', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Custom CSS classes', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'For example: my-custom-class alignleft', 'wplab-albedo-core-plugin' ),
      'param_name' => 'custom_classes',
      'value' => '',
      'group' => esc_html__('Attributes', 'wplab-albedo-core-plugin'),
    ),

    /**
     *  Styling tab
    **/
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Button Style', 'wplab-albedo-core-plugin'),
      'param_name' => 'style',
      'admin_label' => true,
      'value' => $this->cfg['button_styles'],
      'save_always' => true,
      'group' => esc_html__('Styling', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Button Align', 'wplab-albedo-core-plugin'),
      'param_name' => 'align',
      'admin_label' => true,
      'save_always' => true,
      'value' => array(
        esc_html__('None', 'wplab-albedo-core') => '',
        esc_html__( 'Left', 'wplab-albedo-core' ) => 'left',
        esc_html__( 'Center', 'wplab-albedo-core' ) => 'center',
        esc_html__( 'Right', 'wplab-albedo-core' ) => 'right',
      ),
      'group' => esc_html__('Styling', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Button Size', 'wplab-albedo-core-plugin'),
      'param_name' => 'size',
      'admin_label' => true,
      'save_always' => true,
      'value' => array(
        esc_html__( 'Medium', 'wplab-albedo-core' ) => 'medium',
        esc_html__( 'Small', 'wplab-albedo-core' ) => 'small',
        esc_html__( 'Large', 'wplab-albedo-core' ) => 'large',
        esc_html__( 'X Large', 'wplab-albedo-core' ) => 'xlarge',
      ),
      'group' => esc_html__('Styling', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'iconpicker',
      'heading' => esc_html__('Icon', 'wplab-albedo-core-plugin'),
      'param_name' => 'icon',
      'group' => esc_html__('Styling', 'wplab-albedo-core-plugin'),
      'settings' => array(
        'emptyIcon' => true,
        'type' => 'fontawesome',
      )
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Icon position', 'wplab-albedo-core-plugin'),
      'param_name' => 'icon_position',
      'save_always' => true,
      'value' => array(
        esc_html__('Left', 'wplab-albedo-core-plugin') => 'left',
        esc_html__('Right', 'wplab-albedo-core-plugin') => 'right',
      ),
      'group' => esc_html__('Styling', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Animate button', 'wplab-albedo-core-plugin' ),
      'param_name' => 'animation',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('Styling', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Animation Effect', 'wplab-albedo-core-plugin'),
      'param_name' => 'animation_effect',
      'save_always' => true,
      'value' => $this->cfg['animations'],
      'dependency' => array(
  			'element' => 'animation',
  			'not_empty' => true,
  		),
      'group' => esc_html__('Styling', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Animation delay', 'wplab-albedo-core-plugin' ),
      'param_name' => 'animation_delay',
      'save_always' => true,
      'value' => '0.3s',
      'dependency' => array(
  			'element' => 'animation',
  			'not_empty' => true,
  		),
      'group' => esc_html__('Styling', 'wplab-albedo-core-plugin'),
    ),

    /**
     *  Customize tab
    **/
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Border radius', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'value in pixels, e.g.: 30', 'wplab-albedo-core-plugin' ),
      'param_name' => 'border_radius',
      'value' => '',
      'group' => esc_html__('Customize', 'wplab-albedo-core-plugin'),
    ),
    array(
       'type' => 'albedo_sides_box',
       'heading' => esc_html__( 'Button Margins', 'wplab-albedo-core-plugin' ),
       'description' => esc_html__( 'Example: 10px 20% 20px 20%. Follow clockwise: top, right, bottom, left', 'wplab-albedo-core-plugin' ),
       'param_name' => 'margins',
       'group' => esc_html__('Customize', 'wplab-albedo-core-plugin'),
    ),
    array(
       'type' => 'albedo_sides_box',
       'heading' => esc_html__( 'Button Paddings', 'wplab-albedo-core-plugin' ),
       'description' => esc_html__( 'Example: 10px 20% 20px 20%. Follow clockwise: top, right, bottom, left', 'wplab-albedo-core-plugin' ),
       'param_name' => 'paddings',
       'group' => esc_html__('Customize', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Animation time', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'in milliseconds, 1000 = 1 second', 'wplab-albedo-core-plugin' ),
      'param_name' => 'animation_time',
      'value' => '',
      'group' => esc_html__('Customize', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Text Transform', 'wplab-albedo-core-plugin'),
      'param_name' => 'text_transform',
      'value' => array(
        esc_html__('- Default -', 'wplab-albedo-core-plugin') => '',
        esc_html__('None', 'wplab-albedo-core-plugin') => 'none',
				esc_html__('Uppercase', 'wplab-albedo-core-plugin') => 'uppercase',
      ),
      'group' => esc_html__('Customize', 'wplab-albedo-core-plugin'),
    ),
		array(
      'type' => 'dropdown',
      'heading' => esc_html__('Font Style', 'wplab-albedo-core-plugin'),
      'param_name' => 'font_style',
      'value' => array(
        esc_html__('- Default -', 'wplab-albedo-core-plugin') => '',
        esc_html__('Normal', 'wplab-albedo-core-plugin') => 'normal',
				esc_html__('Italic', 'wplab-albedo-core-plugin') => 'italic',
      ),
      'group' => esc_html__('Customize', 'wplab-albedo-core-plugin'),
    ),
		array(
      'type' => 'dropdown',
      'heading' => esc_html__('Font Variant', 'wplab-albedo-core-plugin'),
      'param_name' => 'font_variant',
      'value' => array(
        esc_html__('- Default -', 'wplab-albedo-core-plugin') => '',
        esc_html__('Normal', 'wplab-albedo-core-plugin') => 'normal',
				esc_html__('Small Caps', 'wplab-albedo-core-plugin') => 'small-caps',
      ),
      'group' => esc_html__('Customize', 'wplab-albedo-core-plugin'),
    ),
		array(
      'type' => 'dropdown',
      'heading' => esc_html__('Font Weight', 'wplab-albedo-core-plugin'),
      'param_name' => 'font_weight',
      'value' => array(
        esc_html__('- Default -', 'wplab-albedo-core-plugin') => '',
        esc_html__('Light', 'wplab-albedo-core-plugin') => 'light',
				esc_html__('Normal', 'wplab-albedo-core-plugin') => 'normal',
				esc_html__('Bold', 'wplab-albedo-core-plugin') => 'bold',
				esc_html__('Bolder', 'wplab-albedo-core-plugin') => 'bolder',
				'800' => '800',
				'600' => '600',
				'400' => '400',
				'300' => '300',
				'100' => '100',
      ),
      'group' => esc_html__('Customize', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Custom normal state', 'wplab-albedo-core-plugin' ),
      'param_name' => 'customize_normal_state',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('Customize', 'wplab-albedo-core-plugin'),
    ),
    array(
  		'type' => 'colorpicker',
  		'heading' => esc_html__( 'Text color', 'wplab-albedo-core-plugin' ),
  		'param_name' => 'normal_state_text_color',
  		'value' => '',
      'dependency' => array(
  			'element' => 'customize_normal_state',
  			'not_empty' => true,
  		),
  		'group' => esc_html__('Customize', 'wplab-albedo-core-plugin'),
  	),
    array(
  		'type' => 'colorpicker',
  		'heading' => esc_html__( 'Background color', 'wplab-albedo-core-plugin' ),
  		'param_name' => 'normal_state_background_color',
  		'value' => '',
      'dependency' => array(
  			'element' => 'customize_normal_state',
  			'not_empty' => true,
  		),
  		'group' => esc_html__('Customize', 'wplab-albedo-core-plugin'),
  	),
    array(
  		'type' => 'colorpicker',
  		'heading' => esc_html__( 'Border color', 'wplab-albedo-core-plugin' ),
  		'param_name' => 'normal_state_border_color',
  		'value' => '',
      'dependency' => array(
  			'element' => 'customize_normal_state',
  			'not_empty' => true,
  		),
  		'group' => esc_html__('Customize', 'wplab-albedo-core-plugin'),
  	),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Border size', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'in pixels, e.g. 5', 'wplab-albedo-core-plugin' ),
      'param_name' => 'normal_state_border_size',
      'value' => '',
      'dependency' => array(
  			'element' => 'customize_normal_state',
  			'not_empty' => true,
  		),
      'group' => esc_html__('Customize', 'wplab-albedo-core-plugin'),
    ),
    array(
  		'type' => 'colorpicker',
  		'heading' => esc_html__( 'Shadow color', 'wplab-albedo-core-plugin' ),
  		'param_name' => 'normal_state_shadow_color',
  		'value' => '',
      'dependency' => array(
  			'element' => 'customize_normal_state',
  			'not_empty' => true,
  		),
  		'group' => esc_html__('Customize', 'wplab-albedo-core-plugin'),
  	),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Horizontal shadow length', 'wplab-albedo-core-plugin' ),
      'param_name' => 'normal_state_shadow_h_length',
      'value' => '',
      'dependency' => array(
  			'element' => 'customize_normal_state',
  			'not_empty' => true,
  		),
      'group' => esc_html__('Customize', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Vertical shadow length', 'wplab-albedo-core-plugin' ),
      'param_name' => 'normal_state_shadow_v_length',
      'value' => '',
      'dependency' => array(
  			'element' => 'customize_normal_state',
  			'not_empty' => true,
  		),
      'group' => esc_html__('Customize', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Shadow blur radius', 'wplab-albedo-core-plugin' ),
      'param_name' => 'normal_state_shadow_blur_radius',
      'value' => '',
      'dependency' => array(
  			'element' => 'customize_normal_state',
  			'not_empty' => true,
  		),
      'group' => esc_html__('Customize', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Custom hover state', 'wplab-albedo-core-plugin' ),
      'param_name' => 'customize_hover_state',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('Customize', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'colorpicker',
      'heading' => esc_html__( 'Text color', 'wplab-albedo-core-plugin' ),
      'param_name' => 'hover_state_text_color',
      'value' => '',
      'dependency' => array(
        'element' => 'customize_hover_state',
        'not_empty' => true,
      ),
      'group' => esc_html__('Customize', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'colorpicker',
      'heading' => esc_html__( 'Background color', 'wplab-albedo-core-plugin' ),
      'param_name' => 'hover_state_background_color',
      'value' => '',
      'dependency' => array(
        'element' => 'customize_hover_state',
        'not_empty' => true,
      ),
      'group' => esc_html__('Customize', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'colorpicker',
      'heading' => esc_html__( 'Border color', 'wplab-albedo-core-plugin' ),
      'param_name' => 'hover_state_border_color',
      'value' => '',
      'dependency' => array(
        'element' => 'customize_hover_state',
        'not_empty' => true,
      ),
      'group' => esc_html__('Customize', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Border size', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'in pixels, e.g. 5', 'wplab-albedo-core-plugin' ),
      'param_name' => 'hover_state_border_size',
      'value' => '',
      'dependency' => array(
        'element' => 'customize_hover_state',
        'not_empty' => true,
      ),
      'group' => esc_html__('Customize', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'colorpicker',
      'heading' => esc_html__( 'Shadow color', 'wplab-albedo-core-plugin' ),
      'param_name' => 'hover_state_shadow_color',
      'value' => '',
      'dependency' => array(
        'element' => 'customize_hover_state',
        'not_empty' => true,
      ),
      'group' => esc_html__('Customize', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Horizontal shadow length', 'wplab-albedo-core-plugin' ),
      'param_name' => 'hover_state_shadow_h_length',
      'value' => '',
      'dependency' => array(
        'element' => 'customize_hover_state',
        'not_empty' => true,
      ),
      'group' => esc_html__('Customize', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Vertical shadow length', 'wplab-albedo-core-plugin' ),
      'param_name' => 'hover_state_shadow_v_length',
      'value' => '',
      'dependency' => array(
        'element' => 'customize_hover_state',
        'not_empty' => true,
      ),
      'group' => esc_html__('Customize', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Shadow blur radius', 'wplab-albedo-core-plugin' ),
      'param_name' => 'hover_state_shadow_blur_radius',
      'value' => '',
      'dependency' => array(
        'element' => 'customize_hover_state',
        'not_empty' => true,
      ),
      'group' => esc_html__('Customize', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Custom on click state', 'wplab-albedo-core-plugin' ),
      'param_name' => 'customize_click_state',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('Customize', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'colorpicker',
      'heading' => esc_html__( 'Text color', 'wplab-albedo-core-plugin' ),
      'param_name' => 'click_state_text_color',
      'value' => '',
      'dependency' => array(
        'element' => 'customize_click_state',
        'not_empty' => true,
      ),
      'group' => esc_html__('Customize', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'colorpicker',
      'heading' => esc_html__( 'Background color', 'wplab-albedo-core-plugin' ),
      'param_name' => 'click_state_background_color',
      'value' => '',
      'dependency' => array(
        'element' => 'customize_click_state',
        'not_empty' => true,
      ),
      'group' => esc_html__('Customize', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'colorpicker',
      'heading' => esc_html__( 'Border color', 'wplab-albedo-core-plugin' ),
      'param_name' => 'click_state_border_color',
      'value' => '',
      'dependency' => array(
        'element' => 'customize_click_state',
        'not_empty' => true,
      ),
      'group' => esc_html__('Customize', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Border size', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'in pixels, e.g. 5', 'wplab-albedo-core-plugin' ),
      'param_name' => 'click_state_border_size',
      'value' => '',
      'dependency' => array(
        'element' => 'customize_click_state',
        'not_empty' => true,
      ),
      'group' => esc_html__('Customize', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'colorpicker',
      'heading' => esc_html__( 'Shadow color', 'wplab-albedo-core-plugin' ),
      'param_name' => 'click_state_shadow_color',
      'value' => '',
      'dependency' => array(
        'element' => 'customize_click_state',
        'not_empty' => true,
      ),
      'group' => esc_html__('Customize', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Horizontal shadow length', 'wplab-albedo-core-plugin' ),
      'param_name' => 'click_state_shadow_h_length',
      'value' => '',
      'dependency' => array(
        'element' => 'customize_click_state',
        'not_empty' => true,
      ),
      'group' => esc_html__('Customize', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Vertical shadow length', 'wplab-albedo-core-plugin' ),
      'param_name' => 'click_state_shadow_v_length',
      'value' => '',
      'dependency' => array(
        'element' => 'customize_click_state',
        'not_empty' => true,
      ),
      'group' => esc_html__('Customize', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Shadow blur radius', 'wplab-albedo-core-plugin' ),
      'param_name' => 'click_state_shadow_blur_radius',
      'value' => '',
      'dependency' => array(
        'element' => 'customize_click_state',
        'not_empty' => true,
      ),
      'group' => esc_html__('Customize', 'wplab-albedo-core-plugin'),
    ),

  )
));
