<?php

  /**
    * Blog Minimal Shortcode
  **/

  // Map VC shortcode
  require_once 'config.php';

  if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
    class WPBakeryShortCode_Albedo_Blog_Minimal extends WPBakeryShortCode {

      protected function content( $atts, $content = null ) {
        global $wplab_albedo_core_plugin;

        $atts = vc_map_get_attributes( $this->getShortcode(), $atts );

        $attributes = $wrap_attributes = $classes = array();

        $shortcode_id = 'shortcode-' . $atts['el_id'];

    		$postfix = defined('SCRIPT_DEBUG') && SCRIPT_DEBUG ? '' : '.min';

        wp_enqueue_script( 'youtube-background' );
        wp_enqueue_script( 'wplab-albedo-section-ytbg', wplab_albedo_utils::locate_uri('/framework-customizations/extensions/shortcodes/shortcodes/section/static/js/youtube_bg.js'), array('youtube-background'), _WPLAB_ALBEDO_CACHE_TIME_, true );
    		wp_enqueue_style( 'wplab-albedo-blog-minimal', wplab_albedo_utils::locate_uri( '/css/front/css/shortcodes/blog_minimal.css'), false, _WPLAB_ALBEDO_CACHE_TIME_ );
        $variable_style = $wplab_albedo_core_plugin->lessify( wplab_albedo_utils::locate_uri( '/css/front/less/shortcodes/blog_minimal_variable.less') );
    		wp_enqueue_style( 'wplab-albedo-blog-minimal-variable', $variable_style, false, _WPLAB_ALBEDO_CACHE_TIME_ );

    		/**
    		 * Shortcode scripts
    		 **/
    		wp_enqueue_script( 'wplab-albedo-blog-minimal', wplab_albedo_utils::locate_uri('/framework-customizations/extensions/shortcodes/shortcodes/blog-minimal/static/js/scripts' . $postfix . '.js'), array('jquery'), _WPLAB_ALBEDO_CACHE_TIME_, true );

        ob_start();
        require plugin_dir_path( __FILE__ ) . '/../../vc_templates/albedo_blog_minimal.php';
        return ob_get_clean();

      }

    }
  }
