<?php

  /**
    * Blog Masonry Media Shortcode
  **/

  // Map VC shortcode
  require_once 'config.php';

  if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
    class WPBakeryShortCode_Albedo_Blog_Masonry_Media extends WPBakeryShortCode {

      protected function content( $atts, $content = null ) {
        global $wplab_albedo_core_plugin;

        $atts = vc_map_get_attributes( $this->getShortcode(), $atts );

        $attributes = $wrap_attributes = $classes = array();

        $shortcode_id = 'shortcode-' . $atts['el_id'];

    		$postfix = defined('SCRIPT_DEBUG') && SCRIPT_DEBUG ? '' : '.min';

        /** include Masonry Grid **/
    		wp_enqueue_style( 'masonry', get_template_directory_uri() . '/css/libs/masonry.min.css', false, _WPLAB_ALBEDO_CACHE_TIME_ );
    		wp_enqueue_style( 'masonry-effects', get_template_directory_uri() . '/css/libs/masonry_effects.min.css', false, _WPLAB_ALBEDO_CACHE_TIME_ );
        wp_dequeue_script( 'isotope');
        wp_register_script( 'albedo-isotope', wplab_albedo_utils::locate_uri( '/js/libs/isotope.pkgd.min.js'), array( 'jquery' ), _WPLAB_ALBEDO_CACHE_TIME_, true );
    		wp_enqueue_script( 'albedo-isotope' );
    		wp_enqueue_script( 'anim-on-scroll' );

    		wp_enqueue_style( 'wplab-albedo-blog-masonry-media', wplab_albedo_utils::locate_uri( '/css/front/css/shortcodes/blog_masonry_media.css'), false, _WPLAB_ALBEDO_CACHE_TIME_ );
        $variable_style = $wplab_albedo_core_plugin->lessify( wplab_albedo_utils::locate_uri( '/css/front/less/shortcodes/blog_masonry_media_variable.less') );
    		wp_enqueue_style( 'wplab-albedo-blog-masonry-media-variable', $variable_style, false, _WPLAB_ALBEDO_CACHE_TIME_ );

    		/**
    		 * Shortcode scripts
    		 **/
    		wp_enqueue_script( 'fitvids' );
    		wp_enqueue_script( 'wplab-albedo-blog-masonry-media', wplab_albedo_utils::locate_uri('/framework-customizations/extensions/shortcodes/shortcodes/blog-masonry-media/static/js/scripts' . $postfix . '.js'), array('jquery'), _WPLAB_ALBEDO_CACHE_TIME_, true );

    		// custom styles
    		if( $atts['custom_radius'] <> '' ) {
    			$radius = absint( $atts['custom_radius'] );
    			$custom_css = ' #' . $shortcode_id . ' .shortcode-blog-masonry-media .item, #' . $shortcode_id . ' .shortcode-blog-masonry-media .overlay { border-radius: ' . $radius . 'px; }';
          $wrap_attributes[] = 'data-custom-css=\'' . $custom_css . '\'';
    		}

        ob_start();
        require plugin_dir_path( __FILE__ ) . '/../../vc_templates/albedo_blog_masonry_media.php';
        return ob_get_clean();

      }

    }
  }
