<?php

vc_map( array(
  'name' => esc_html__( 'Benefits Numeric', 'wplab-albedo-core-plugin' ),
	'base' => 'albedo_benefits_numeric',
  'icon' => $this->plugin_uri . '/assets/shortcode_icons/benefits-numeric.png',
  'front_enqueue_js' => $this->plugin_uri . '/shortcodes/benefits-numeric/js/vc.js',
	'category' => esc_html__( 'Services', 'wplab-albedo-core-plugin' ),
	'description' => esc_html__( 'Add numeric benefits shortcode', 'wplab-albedo-core-plugin' ),
	'params' => array(

    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Number', 'wplab-albedo-core-plugin' ),
      'param_name' => 'number',
      'admin_label' => true,
      'value' => '',
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Title', 'wplab-albedo-core-plugin' ),
      'param_name' => 'title',
      'admin_label' => true,
      'value' => '',
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textarea',
      'heading' => esc_html__( 'Text', 'wplab-albedo-core-plugin' ),
      'param_name' => 'text',
      'admin_label' => true,
      'value' => '',
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Link (optional)', 'wplab-albedo-core-plugin' ),
      'param_name' => 'link',
      'value' => '',
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'attach_image',
      'heading' => esc_html__('Background image', 'wplab-albedo-core-plugin'),
      'description' => esc_html__( 'Can be used only for Photo Background style', 'wplab-albedo-core-plugin'),
      'param_name' => 'background_image',
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'el_id',
      'heading' => esc_html__( 'Element ID', 'wplab-albedo-core-plugin' ),
      'param_name' => 'el_id',
      'settings' => array(
        'auto_generate' => true,
      ),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
      'description' => esc_html__( 'Unique identifier of this element', 'wplab-albedo-core-plugin' ),
    ),

    /**
     * Style tab
    **/

    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Style', 'wplab-albedo-core-plugin'),
      'param_name' => 'style',
      'save_always' => true,
      'admin_label' => true,
      'value' => array(
        esc_html__('Default', 'wplab-albedo-core-plugin') => 'default',
        esc_html__('Photo background', 'wplab-albedo-core-plugin') => 'photo',
      ),
      'group' => esc_html__('Style', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Open links at new tab', 'wplab-albedo-core-plugin' ),
      'param_name' => 'link_target',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('Style', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Display button', 'wplab-albedo-core-plugin' ),
      'param_name' => 'display_button',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('Style', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Button title', 'wplab-albedo-core-plugin' ),
      'param_name' => 'button_title',
      'admin_label' => true,
      'save_always' => true,
      'value' => esc_html__( 'READ MORE', 'wplab-albedo-core-plugin' ),
      'dependency' => array(
  			'element' => 'display_button',
  			'not_empty' => true,
  		),
      'group' => esc_html__('Style', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Button style', 'wplab-albedo-core-plugin'),
      'description' => esc_html__('Here you can choose pre-defined styles for a button', 'wplab-albedo-core-plugin'),
      'param_name' => 'button_style',
      'save_always' => true,
      'value' => $this->cfg['button_styles'],
      'dependency' => array(
  			'element' => 'display_button',
  			'not_empty' => true,
  		),
      'group' => esc_html__('Style', 'wplab-albedo-core-plugin'),
    ),



    /**
     * Animation tab
    **/
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Animate on display', 'wplab-albedo-core-plugin' ),
      'param_name' => 'animate_on_display',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('Animation', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Animation Effect', 'wplab-albedo-core-plugin'),
      'param_name' => 'animate_on_display_effect',
      'save_always' => true,
      'value' => $this->cfg['animations'],
      'dependency' => array(
  			'element' => 'animate_on_display',
  			'not_empty' => true,
  		),
      'group' => esc_html__('Animation', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Animation delay', 'wplab-albedo-core-plugin' ),
      'param_name' => 'animate_on_display_delay',
      'save_always' => true,
      'value' => '0.2',
      'dependency' => array(
  			'element' => 'animate_on_display',
  			'not_empty' => true,
  		),
      'group' => esc_html__('Animation', 'wplab-albedo-core-plugin'),
    ),


    /**
     * Colors tab
    **/
    array(
  		'type' => 'colorpicker',
  		'heading' => esc_html__( 'Number color', 'wplab-albedo-core-plugin' ),
  		'param_name' => 'number_color',
  		'value' => '',
  		'group' => esc_html__('Colors', 'wplab-albedo-core-plugin'),
  	),
    array(
  		'type' => 'colorpicker',
  		'heading' => esc_html__( 'Number hover color', 'wplab-albedo-core-plugin' ),
  		'param_name' => 'number_hover_color',
  		'value' => '',
  		'group' => esc_html__('Colors', 'wplab-albedo-core-plugin'),
  	),
    array(
  		'type' => 'colorpicker',
  		'heading' => esc_html__( 'Header color', 'wplab-albedo-core-plugin' ),
  		'param_name' => 'header_color',
  		'value' => '',
  		'group' => esc_html__('Colors', 'wplab-albedo-core-plugin'),
  	),
    array(
  		'type' => 'colorpicker',
  		'heading' => esc_html__( 'Header hover color', 'wplab-albedo-core-plugin' ),
  		'param_name' => 'header_hover_color',
  		'value' => '',
  		'group' => esc_html__('Colors', 'wplab-albedo-core-plugin'),
  	),
    array(
  		'type' => 'colorpicker',
  		'heading' => esc_html__( 'Text color', 'wplab-albedo-core-plugin' ),
  		'param_name' => 'text_color',
  		'value' => '',
  		'group' => esc_html__('Colors', 'wplab-albedo-core-plugin'),
  	),

  )
));
