<?php

  /**
    * Benefits Modern Shortcode
  **/

  // Map VC shortcode
  require_once 'config.php';


  //Your "container" content element should extend WPBakeryShortCodesContainer class to inherit all required functionality
  if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
    class WPBakeryShortCode_Albedo_Benefits_Modern extends WPBakeryShortCode {

      protected function content( $atts, $content = null ) {
        global $wplab_albedo_core, $wplab_albedo_core_plugin;

        $atts = vc_map_get_attributes( $this->getShortcode(), $atts );

        fw()->backend->option_type('icon-v2')->packs_loader->enqueue_frontend_css();

        $attributes = $classes = array();

        $shortcode_id = 'shortcode-' . $atts['el_id'];

    		$postfix = defined('SCRIPT_DEBUG') && SCRIPT_DEBUG ? '' : '.min';

        /** load stylesheet **/
        wp_enqueue_style( 'wplab-albedo-benefits-modern', wplab_albedo_utils::locate_uri( '/css/front/css/shortcodes/benefits_modern.css'), false, _WPLAB_ALBEDO_CACHE_TIME_ );

        $variable_style = $wplab_albedo_core_plugin->lessify( wplab_albedo_utils::locate_uri( '/css/front/less/shortcodes/benefits_modern_variable.less') );
        wp_enqueue_style( 'wplab-albedo-benefits-modern-variable', $variable_style, false, _WPLAB_ALBEDO_CORE_CACHE_TIME_ );

        /**
         * Shortcode scripts
         **/
        wp_enqueue_script( 'wplab-albedo-benefits', wplab_albedo_utils::locate_uri('/framework-customizations/extensions/shortcodes/shortcodes/benefits/static/js/scripts.js'), array('jquery'), _WPLAB_ALBEDO_CACHE_TIME_, true );

    		/**
    		 * Custom colors
    		 **/

        $custom_css = '';

        /**
         * Custom colors
         **/

        if( $atts['icon_color'] <> '' ) {

          $inline_css = ' #' . $shortcode_id . ' .icon { color: ' . $atts['icon_color'] . '; }';
          $inline_css .= ' #' . $shortcode_id . ' svg path, #' . $shortcode_id . ' svg rect, #' . $shortcode_id . ' svg polygon, #' . $shortcode_id . ' svg circle { fill: ' . $atts['icon_color'] . '; }';
          $custom_css .= $inline_css;

        }

        if( $atts['icon_hover_color'] <> '' ) {

          $inline_css = ' #' . $shortcode_id . ' .item:hover .icon { color: ' . $atts['icon_hover_color'] . '; }';
          $inline_css .= ' #' . $shortcode_id . ' .item:hover svg path, #' . $shortcode_id . ' .item:hover svg rect, #' . $shortcode_id . ' .item:hover svg polygon, #' . $shortcode_id . ' .item:hover svg circle { fill: ' . $atts['icon_hover_color'] . '; }';
          $custom_css .= $inline_css;

        }

        if( $atts['header_color'] <> '' ) {
          $inline_css = ' #' . $shortcode_id . ' h4 { color: ' . $atts['header_color'] . '; }';
          $custom_css .= $inline_css;
        }

        if( $atts['header_hover_color'] <> '' ) {
          $inline_css = ' #' . $shortcode_id . ' .item:hover h4 { color: ' . $atts['header_hover_color'] . '; }';
          $custom_css .= $inline_css;
        }

        if( $atts['text_color'] <> '' ) {
          $inline_css = ' #' . $shortcode_id . ' .desc { color: ' . $atts['text_color'] . '; }';
          $custom_css .= $inline_css;
        }

        if( $atts['button_color'] <> '' ) {
          $inline_css = ' #' . $shortcode_id . ' .btn { background-image: ~\'url("data:image/svg+xml;charset=UTF-8,%3Csvg%20version%3D%221.1%22%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20xmlns%3Axlink%3D%22http%3A%2F%2Fwww.w3.org%2F1999%2Fxlink%22%20x%3D%220px%22%20y%3D%220px%22%0A%09%20width%3D%22284.935px%22%20height%3D%22284.936px%22%20viewBox%3D%220%200%20284.935%20284.936%22%20style%3D%22enable-background%3Anew%200%200%20284.935%20284.936%3B%22%0A%09%20xml%3Aspace%3D%22preserve%22%3E%0A%3Cg%3E%0A%09%3Cpath%20fill%3D%22' . urlencode( $atts['button_color'] ) . '%22%20d%3D%22M222.701%2C135.9L89.652%2C2.857C87.748%2C0.955%2C85.557%2C0%2C83.084%2C0c-2.474%2C0-4.664%2C0.955-6.567%2C2.857L62.244%2C17.133%0A%09%09c-1.906%2C1.903-2.855%2C4.089-2.855%2C6.567c0%2C2.478%2C0.949%2C4.664%2C2.855%2C6.567l112.204%2C112.204L62.244%2C254.677%0A%09%09c-1.906%2C1.903-2.855%2C4.093-2.855%2C6.564c0%2C2.477%2C0.949%2C4.667%2C2.855%2C6.57l14.274%2C14.271c1.903%2C1.905%2C4.093%2C2.854%2C6.567%2C2.854%0A%09%09c2.473%2C0%2C4.663-0.951%2C6.567-2.854l133.042-133.044c1.902-1.902%2C2.854-4.093%2C2.854-6.567S224.603%2C137.807%2C222.701%2C135.9z%22%2F%3E%0A%3C%2Fg%3E%0A%3C%2Fsvg%3E")\'; }';
          $custom_css .= $inline_css;
        }

        if( $atts['button_hover_color'] <> '' ) {
          $inline_css = ' #' . $shortcode_id . ' .btn:hover { background-image: ~\'url("data:image/svg+xml;charset=UTF-8,%3Csvg%20version%3D%221.1%22%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20xmlns%3Axlink%3D%22http%3A%2F%2Fwww.w3.org%2F1999%2Fxlink%22%20x%3D%220px%22%20y%3D%220px%22%0A%09%20width%3D%22284.935px%22%20height%3D%22284.936px%22%20viewBox%3D%220%200%20284.935%20284.936%22%20style%3D%22enable-background%3Anew%200%200%20284.935%20284.936%3B%22%0A%09%20xml%3Aspace%3D%22preserve%22%3E%0A%3Cg%3E%0A%09%3Cpath%20fill%3D%22' . urlencode( $atts['button_color'] ) . '%22%20d%3D%22M222.701%2C135.9L89.652%2C2.857C87.748%2C0.955%2C85.557%2C0%2C83.084%2C0c-2.474%2C0-4.664%2C0.955-6.567%2C2.857L62.244%2C17.133%0A%09%09c-1.906%2C1.903-2.855%2C4.089-2.855%2C6.567c0%2C2.478%2C0.949%2C4.664%2C2.855%2C6.567l112.204%2C112.204L62.244%2C254.677%0A%09%09c-1.906%2C1.903-2.855%2C4.093-2.855%2C6.564c0%2C2.477%2C0.949%2C4.667%2C2.855%2C6.57l14.274%2C14.271c1.903%2C1.905%2C4.093%2C2.854%2C6.567%2C2.854%0A%09%09c2.473%2C0%2C4.663-0.951%2C6.567-2.854l133.042-133.044c1.902-1.902%2C2.854-4.093%2C2.854-6.567S224.603%2C137.807%2C222.701%2C135.9z%22%2F%3E%0A%3C%2Fg%3E%0A%3C%2Fsvg%3E")\'; }';
          $custom_css .= $inline_css;
        }

        if( $custom_css <> '' ) {
          $attributes[] = 'data-custom-css=\'' . $custom_css . '\'';
        }

        ob_start();
        require plugin_dir_path( __FILE__ ) . '/../../vc_templates/albedo_benefits_modern.php';
        return ob_get_clean();

      }

    }
  }
